/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Obayashi
extends AbstractProblem
implements AnalyticalProblem {
    public Obayashi() {
        super(2, 2, 1);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        double y = EncodingUtils.getReal(solution.getVariable(1));
        double c = Math.pow(x, 2.0) + Math.pow(y, 2.0) - 1.0;
        solution.setObjective(0, -x);
        solution.setObjective(1, -y);
        solution.setConstraint(0, c <= 0.0 ? 0.0 : c);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(2, 2, 1);
        solution.setVariable(0, EncodingUtils.newReal(0.0, 1.0));
        solution.setVariable(1, EncodingUtils.newReal(0.0, 1.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        double x = PRNG.nextDouble(0.0, 1.0);
        double y = Math.sqrt(1.0 - Math.pow(x, 2.0));
        EncodingUtils.setReal(solution.getVariable(0), x);
        EncodingUtils.setReal(solution.getVariable(1), y);
        this.evaluate(solution);
        return solution;
    }
}

