/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.AbstractProblem;

public class Quagliarella
extends AbstractProblem {
    public Quagliarella() {
        this(16);
    }

    public Quagliarella(int numberOfVariables) {
        super(numberOfVariables, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double A1 = 0.0;
        double A2 = 0.0;
        for (int i = 0; i < this.numberOfVariables; ++i) {
            A1 += Math.pow(x[i], 2.0) - 10.0 * Math.cos(Math.PI * 2 * x[i]) + 10.0;
            A2 += Math.pow(x[i] - 1.5, 2.0) - 10.0 * Math.cos(Math.PI * 2 * (x[i] - 1.5)) + 10.0;
        }
        solution.setObjective(0, Math.sqrt(A1 / (double)this.numberOfVariables));
        solution.setObjective(1, Math.sqrt(A2 / (double)this.numberOfVariables));
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, 2);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(-5.12, 5.12));
        }
        return solution;
    }
}

