/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Schaffer
extends AbstractProblem
implements AnalyticalProblem {
    public Schaffer() {
        super(1, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        solution.setObjective(0, Math.pow(x, 2.0));
        solution.setObjective(1, Math.pow(x - 2.0, 2.0));
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(1, 2);
        solution.setVariable(0, EncodingUtils.newReal(-10.0, 10.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        EncodingUtils.setReal(solution.getVariable(0), PRNG.nextDouble(0.0, 2.0));
        this.evaluate(solution);
        return solution;
    }
}

