/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Schaffer2
extends AbstractProblem
implements AnalyticalProblem {
    public Schaffer2() {
        super(1, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        if (x <= 1.0) {
            solution.setObjective(0, -x);
        } else if (x <= 3.0) {
            solution.setObjective(0, -2.0 + x);
        } else if (x <= 4.0) {
            solution.setObjective(0, 4.0 - x);
        } else {
            solution.setObjective(0, -4.0 + x);
        }
        solution.setObjective(1, Math.pow(x - 5.0, 2.0));
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(1, 2);
        solution.setVariable(0, EncodingUtils.newReal(-5.0, 10.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        if (PRNG.nextBoolean()) {
            EncodingUtils.setReal(solution.getVariable(0), PRNG.nextDouble(1.0, 2.0));
        } else {
            EncodingUtils.setReal(solution.getVariable(0), PRNG.nextDouble(4.0, 5.0));
        }
        this.evaluate(solution);
        return solution;
    }
}

