/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.moeaframework.util.Localization;

public abstract class CommandLineUtility {
    private String commandString = null;

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create((char)'h'));
        return options;
    }

    public abstract void run(CommandLine var1) throws Exception;

    public void start(String[] args) throws Exception {
        Options options;
        GnuParser commandLineParser;
        CommandLine commandLine;
        Thread.currentThread().setUncaughtExceptionHandler(new CommandLineUncaughtExceptionHandler());
        if (args.length > 0) {
            args[args.length - 1] = args[args.length - 1].trim();
        }
        if ((commandLine = (commandLineParser = new GnuParser()).parse(options = this.getOptions(), args)).hasOption("help")) {
            this.showHelp();
        } else {
            this.run(commandLine);
        }
    }

    private void showHelp() {
        Options options = this.getOptions();
        block0: for (Object object : options.getOptions()) {
            Option option = (Option)object;
            String key = "option." + option.getLongOpt();
            Class<?> type = this.getClass();
            while (CommandLineUtility.class.isAssignableFrom(type)) {
                if (Localization.containsKey(type, key)) {
                    option.setDescription(Localization.getString(type, key));
                    continue block0;
                }
                type = type.getSuperclass();
            }
        }
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(this.getCommandString(), Localization.getString(this.getClass(), "description"), options, Localization.getString(CommandLineUtility.class, "footer"), true);
    }

    public String getCommandString() {
        if (this.commandString == null) {
            return "java " + this.getClass().getName();
        }
        return this.commandString;
    }

    public void setCommandString(String commandString) {
        this.commandString = commandString;
    }

    private class CommandLineUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CommandLineUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof ParseException) {
                System.err.println(e.getMessage());
                CommandLineUtility.this.showHelp();
            } else {
                e.printStackTrace();
            }
        }
    }
}

