/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localization {
    private final ResourceBundle bundle;

    private Localization(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    public String getString(String key) {
        try {
            if (this.bundle == null) {
                return key;
            }
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public boolean containsKey(String key) {
        if (this.bundle == null) {
            return false;
        }
        return this.bundle.containsKey(key);
    }

    public String getString(String key, Object ... arguments) {
        MessageFormat format = new MessageFormat(this.getString(key), this.getLocale());
        return format.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static Localization getLocalization(String packageName) {
        return Localization.getLocalization(packageName, Locale.getDefault());
    }

    public static Localization getLocalization(String packageName, Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(packageName + ".LocalStrings", locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return new Localization(bundle);
    }

    public static Localization getLocalization(Class<?> type) {
        return Localization.getLocalization(type.getPackage().getName());
    }

    public static Localization getLocalization(Class<?> type, Locale locale) {
        return Localization.getLocalization(type.getPackage().getName(), locale);
    }

    public static boolean containsKey(Class<?> type, String key) {
        return Localization.getLocalization(type).containsKey(type.getSimpleName() + "." + key);
    }

    public static String getString(Class<?> type, String key) {
        return Localization.getLocalization(type).getString(type.getSimpleName() + "." + key);
    }

    public static String getString(Class<?> type, String key, Object ... arguments) {
        return Localization.getLocalization(type).getString(type.getSimpleName() + "." + key, arguments);
    }
}

