/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.util.MathArrays;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Solution;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.TypedProperties;

public class ReferenceSetMerger
extends CommandLineUtility {
    public static final String SOURCE_ATTRIBUTE = "source";
    private NondominatedPopulation combinedPopulation;
    private Map<String, Population> populations;

    public ReferenceSetMerger() {
        this(new NondominatedPopulation());
    }

    public ReferenceSetMerger(NondominatedPopulation combinedPopulation) {
        this.combinedPopulation = combinedPopulation;
        this.populations = new HashMap<String, Population>();
    }

    public void add(String source, Population population) {
        if (this.populations.containsKey(source)) {
            throw new IllegalArgumentException("source already exists");
        }
        this.populations.put(source, population);
        for (Solution solution : population) {
            solution.setAttribute(SOURCE_ATTRIBUTE, (Serializable)((Object)source));
            for (Solution s : this.combinedPopulation) {
                if (!(MathArrays.distance((double[])s.getObjectives(), (double[])solution.getObjectives()) < 1.0E-10)) continue;
                System.err.println("duplicate solution found");
            }
            this.combinedPopulation.add(solution);
        }
    }

    public NondominatedPopulation getCombinedPopulation() {
        return this.combinedPopulation;
    }

    public Set<String> getSources() {
        return this.populations.keySet();
    }

    public Population getPopulation(String source) {
        return this.populations.get(source);
    }

    public NondominatedPopulation getContributionFrom(String source) {
        NondominatedPopulation result = new NondominatedPopulation();
        for (Solution solution : this.combinedPopulation) {
            if (!solution.getAttribute(SOURCE_ATTRIBUTE).equals(source)) continue;
            result.add(solution);
        }
        return result;
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"epsilon");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"e1,e2,...");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"diff");
        options.addOption(OptionBuilder.create((char)'d'));
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption("epsilon")) {
            TypedProperties properties = TypedProperties.withProperty("epsilon", commandLine.getOptionValue("epsilon"));
            this.combinedPopulation = new EpsilonBoxDominanceArchive(properties.getDoubleArray("epsilon", null));
        }
        for (String filename : commandLine.getArgs()) {
            this.add(filename, PopulationIO.readObjectives(new File(filename)));
        }
        if (commandLine.hasOption("output")) {
            PopulationIO.writeObjectives(new File(commandLine.getOptionValue("output")), this.getCombinedPopulation());
        }
        if (commandLine.hasOption("diff")) {
            for (String filename : commandLine.getArgs()) {
                PopulationIO.writeObjectives(new File(filename + ".diff"), this.getContributionFrom(filename));
            }
        }
        for (String filename : commandLine.getArgs()) {
            System.out.print(filename);
            System.out.print(": ");
            System.out.print(this.getContributionFrom(filename).size());
            System.out.print(" / ");
            System.out.println(this.getPopulation(filename).size());
        }
    }

    public static void main(String[] args) throws Exception {
        new ReferenceSetMerger().start(args);
    }
}

