/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.moeaframework.core.PRNG;

public class RotationMatrixBuilder {
    private final int dimension;
    private final List<Plane> planes;

    public RotationMatrixBuilder(int dimension) {
        this.dimension = dimension;
        this.planes = new ArrayList<Plane>();
    }

    public RotationMatrixBuilder rotatePlane(int i, int j) {
        if (i < 0 || i >= this.dimension || j < 0 || j >= this.dimension || i == j) {
            throw new IllegalArgumentException("invalid plane");
        }
        this.planes.add(new Plane(i, j));
        return this;
    }

    public RotationMatrixBuilder withTheta(double theta) {
        this.planes.get(this.planes.size() - 1).setTheta(theta);
        return this;
    }

    public RotationMatrixBuilder withThetas(double theta) {
        for (Plane plane : this.planes) {
            plane.setTheta(theta);
        }
        return this;
    }

    public RotationMatrixBuilder withRandomThetas() {
        for (Plane plane : this.planes) {
            plane.setTheta(PRNG.nextDouble(0.0, Math.PI * 2));
        }
        return this;
    }

    public RotationMatrixBuilder rotateAll() {
        for (int i = 0; i < this.dimension - 1; ++i) {
            for (int j = i + 1; j < this.dimension; ++j) {
                Plane plane = new Plane(i, j);
                plane.setTheta(PRNG.nextDouble(0.0, Math.PI * 2));
                this.planes.add(plane);
            }
        }
        return this;
    }

    public RotationMatrixBuilder rotateK(int k) {
        int i;
        ArrayList<Plane> tempPlanes = new ArrayList<Plane>();
        for (i = 0; i < this.dimension - 1; ++i) {
            for (int j = i + 1; j < this.dimension; ++j) {
                tempPlanes.add(new Plane(i, j));
            }
        }
        if (k < 0 || k > tempPlanes.size()) {
            throw new IllegalArgumentException("invalid number of planes");
        }
        PRNG.shuffle(tempPlanes);
        this.planes.clear();
        for (i = 0; i < k; ++i) {
            Plane plane = (Plane)tempPlanes.get(i);
            plane.setTheta(PRNG.nextDouble(0.0, Math.PI * 2));
            this.planes.add(plane);
        }
        return this;
    }

    public RealMatrix create() {
        RealMatrix rotation = this.newIdentityMatrix();
        for (Plane plane : this.planes) {
            double theta = plane.getTheta();
            if (Double.isNaN(theta)) continue;
            rotation = rotation.multiply(this.newRotationMatrix(plane.getFirstAxis(), plane.getSecondAxis(), theta));
        }
        return rotation;
    }

    private RealMatrix newIdentityMatrix() {
        RealMatrix identity = MatrixUtils.createRealMatrix((int)this.dimension, (int)this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            identity.setEntry(i, i, 1.0);
        }
        return identity;
    }

    private RealMatrix newRotationMatrix(int i, int j, double theta) {
        RealMatrix rotation = this.newIdentityMatrix();
        rotation.setEntry(i, i, Math.cos(theta));
        rotation.setEntry(i, j, -Math.sin(theta));
        rotation.setEntry(j, i, Math.sin(theta));
        rotation.setEntry(j, j, Math.cos(theta));
        return rotation;
    }

    private static class Plane {
        private final int firstAxis;
        private final int secondAxis;
        private double theta;

        public Plane(int firstAxis, int secondAxis) {
            this.firstAxis = firstAxis;
            this.secondAxis = secondAxis;
            this.theta = Double.NaN;
        }

        public int getFirstAxis() {
            return this.firstAxis;
        }

        public int getSecondAxis() {
            return this.secondAxis;
        }

        public double getTheta() {
            return this.theta;
        }

        public void setTheta(double theta) {
            this.theta = theta;
        }
    }
}

