/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class Timing {
    private static Map<String, Long> openTimers = new HashMap<String, Long>();
    private static Map<String, SummaryStatistics> data = new HashMap<String, SummaryStatistics>();

    private Timing() {
    }

    public static void startTimer(String name) {
        if (openTimers.containsKey(name)) {
            throw new IllegalArgumentException("timer already exists");
        }
        openTimers.put(name, System.nanoTime());
    }

    public static void stopTimer(String name) {
        long stopTime = System.nanoTime();
        Long startTime = openTimers.remove(name);
        if (startTime == null) {
            throw new IllegalArgumentException("timer does not exist");
        }
        SummaryStatistics statistics = data.get(name);
        if (statistics == null) {
            statistics = new SummaryStatistics();
            data.put(name, statistics);
        }
        statistics.addValue((double)(stopTime - startTime));
    }

    public static SummaryStatistics getStatistics(String name) {
        return data.get(name);
    }

    public static void printStatistics() {
        Timing.printStatistics(System.out);
    }

    public static void printStatistics(PrintStream out) {
        for (Map.Entry<String, SummaryStatistics> entry : data.entrySet()) {
            out.print(entry.getKey());
            out.print(": ");
            out.print(entry.getValue().getMin() / 1.0E9);
            out.print(' ');
            out.print(entry.getValue().getMean() / 1.0E9);
            out.print(' ');
            out.print(entry.getValue().getMax() / 1.0E9);
            out.print(' ');
            out.print(entry.getValue().getN());
            out.println();
        }
    }

    public static void printMagnitudes() {
        Timing.printMagnitudes(System.out);
    }

    public static void printMagnitudes(PrintStream out) {
        double min = Double.POSITIVE_INFINITY;
        for (Map.Entry<String, SummaryStatistics> entry : data.entrySet()) {
            min = Math.min(min, entry.getValue().getMean());
        }
        for (Map.Entry<String, SummaryStatistics> entry : data.entrySet()) {
            out.print(entry.getKey());
            out.print(": ");
            out.print(entry.getValue().getMean() / min);
            out.println();
        }
    }

    public static void clear() {
        data.clear();
    }
}

