/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Properties;

public class TypedProperties {
    public static final String DEFAULT_SEPARATOR = ",";
    private final String separator;
    private final Properties properties;

    public TypedProperties() {
        this(new Properties());
    }

    public TypedProperties(Properties properties) {
        this(properties, DEFAULT_SEPARATOR);
    }

    public TypedProperties(Properties properties, String separator) {
        this.properties = properties;
        this.separator = separator;
    }

    public static TypedProperties withProperty(String key, String value) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        return new TypedProperties(properties);
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getString(String key, String defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public short getShort(String key, short defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Short.parseShort(value);
    }

    public byte getByte(String key, byte defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Byte.parseByte(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String[] getStringArray(String key, String[] defaultValues) {
        String value = this.getString(key, null);
        if (value == null) {
            return defaultValues;
        }
        if (value.isEmpty()) {
            return new String[0];
        }
        String[] tokens = value.split(this.separator, -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    public double[] getDoubleArray(String key, double[] defaultValues) {
        String[] values = this.getStringArray(key, null);
        if (values == null) {
            return defaultValues;
        }
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Double.parseDouble(values[i]);
        }
        return result;
    }

    public float[] getFloatArray(String key, float[] defaultValues) {
        String[] values = this.getStringArray(key, null);
        if (values == null) {
            return defaultValues;
        }
        float[] result = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Float.parseFloat(values[i]);
        }
        return result;
    }

    public long[] getLongArray(String key, long[] defaultValues) {
        String[] values = this.getStringArray(key, null);
        if (values == null) {
            return defaultValues;
        }
        long[] result = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Long.parseLong(values[i]);
        }
        return result;
    }

    public int[] getIntArray(String key, int[] defaultValues) {
        String[] values = this.getStringArray(key, null);
        if (values == null) {
            return defaultValues;
        }
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public short[] getShortArray(String key, short[] defaultValues) {
        String[] values = this.getStringArray(key, null);
        if (values == null) {
            return defaultValues;
        }
        short[] result = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Short.parseShort(values[i]);
        }
        return result;
    }

    public byte[] getByteArray(String key, byte[] defaultValues) {
        String[] values = this.getStringArray(key, null);
        if (values == null) {
            return defaultValues;
        }
        byte[] result = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Byte.parseByte(values[i]);
        }
        return result;
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setFloat(String key, float value) {
        this.setString(key, Float.toString(value));
    }

    public void setDouble(String key, double value) {
        this.setString(key, Double.toString(value));
    }

    public void setByte(String key, byte value) {
        this.setString(key, Byte.toString(value));
    }

    public void setShort(String key, short value) {
        this.setString(key, Short.toString(value));
    }

    public void setInt(String key, int value) {
        this.setString(key, Integer.toString(value));
    }

    public void setLong(String key, long value) {
        this.setString(key, Long.toString(value));
    }

    public void setBoolean(String key, boolean value) {
        this.setString(key, Boolean.toString(value));
    }

    public void setStringArray(String key, String[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void setFloatArray(String key, float[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void setDoubleArray(String key, double[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void setByteArray(String key, byte[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void setShortArray(String key, short[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void setIntArray(String key, int[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void setLongArray(String key, long[] values) {
        this.setString(key, this.arrayToString(values));
    }

    public void clear() {
        this.properties.clear();
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public void addAll(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addAll(TypedProperties properties) {
        this.addAll(properties.getProperties());
    }

    private String arrayToString(Object array) {
        StringBuilder sb = new StringBuilder();
        Class<?> type = array.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException("not an array");
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (i > 0) {
                sb.append(this.separator);
            }
            sb.append(Array.get(array, i));
        }
        return sb.toString();
    }
}

