/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util;

public class Vector {
    private Vector() {
    }

    private static int length(double[] u, double[] v) {
        if (u.length != v.length) {
            throw new IllegalArgumentException("vectors must have same length");
        }
        return u.length;
    }

    public static double[] subtract(double[] u, double[] v) {
        int n = Vector.length(u, v);
        double[] w = new double[n];
        for (int i = 0; i < n; ++i) {
            w[i] = u[i] - v[i];
        }
        return w;
    }

    public static double[] add(double[] u, double[] v) {
        int n = Vector.length(u, v);
        double[] w = new double[n];
        for (int i = 0; i < n; ++i) {
            w[i] = u[i] + v[i];
        }
        return w;
    }

    public static double[] multiply(double a, double[] u) {
        int n = u.length;
        double[] w = new double[n];
        for (int i = 0; i < n; ++i) {
            w[i] = a * u[i];
        }
        return w;
    }

    public static double[] negate(double[] u) {
        return Vector.multiply(-1.0, u);
    }

    public static double[] divide(double[] u, double a) {
        return Vector.multiply(1.0 / a, u);
    }

    public static double dot(double[] u, double[] v) {
        int n = Vector.length(u, v);
        double dot = 0.0;
        for (int i = 0; i < n; ++i) {
            dot += u[i] * v[i];
        }
        return dot;
    }

    public static double magnitude(double[] u) {
        return Math.sqrt(Vector.dot(u, u));
    }

    public static double[] normalize(double[] u) {
        if (Vector.isZero(u)) {
            throw new IllegalArgumentException("can not normalize zero vector");
        }
        return Vector.multiply(1.0 / Vector.magnitude(u), u);
    }

    public static double[] project(double[] u, double[] v) {
        return Vector.multiply(Vector.dot(u, v) / Vector.dot(v, v), v);
    }

    public static double[][] orthogonalize(double[][] vs) {
        vs = (double[][])vs.clone();
        for (int i = 1; i < vs.length; ++i) {
            for (int j = 0; j < i; ++j) {
                vs[i] = Vector.subtract(vs[i], Vector.project(vs[i], vs[j]));
            }
        }
        return vs;
    }

    public static double[] orthogonalize(double[] u, Iterable<double[]> vs) {
        for (double[] v : vs) {
            u = Vector.subtract(u, Vector.project(u, v));
        }
        return u;
    }

    public static double[] mean(double[][] vs) {
        int k = vs.length;
        if (k == 0) {
            throw new IllegalArgumentException("empty vector");
        }
        int n = vs[0].length;
        double[] mean = new double[n];
        int j = 0;
        while (j < n) {
            for (int i = 0; i < k; ++i) {
                int n2 = j;
                mean[n2] = mean[n2] + vs[i][j];
            }
            int n3 = j++;
            mean[n3] = mean[n3] / (double)k;
        }
        return mean;
    }

    public static boolean isZero(double[] u) {
        for (int i = 0; i < u.length; ++i) {
            if (!(Math.abs(u[i]) > 1.0E-10)) continue;
            return false;
        }
        return true;
    }
}

