/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.distributed;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.problem.ProblemException;
import org.moeaframework.util.distributed.FutureSolution;

public class DistributedProblem
implements Problem {
    private final ExecutorService executor;
    private final Problem innerProblem;

    public DistributedProblem(Problem problem, ExecutorService executor) {
        this.innerProblem = problem;
        this.executor = executor;
    }

    @Override
    public void evaluate(Solution solution) {
        if (!(solution instanceof FutureSolution)) {
            throw new ProblemException((Problem)this, "requires FutureSolution");
        }
        FutureSolution futureSolution = (FutureSolution)solution;
        Future<Solution> future = this.executor.submit(new ProblemEvaluator(this.innerProblem, futureSolution));
        futureSolution.setFuture(future);
    }

    @Override
    public String getName() {
        return this.innerProblem.getName();
    }

    @Override
    public int getNumberOfConstraints() {
        return this.innerProblem.getNumberOfConstraints();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.innerProblem.getNumberOfObjectives();
    }

    @Override
    public int getNumberOfVariables() {
        return this.innerProblem.getNumberOfVariables();
    }

    @Override
    public Solution newSolution() {
        return new FutureSolution(this.innerProblem.newSolution());
    }

    @Override
    public void close() {
        this.innerProblem.close();
    }

    private static class ProblemEvaluator
    implements Callable<Solution>,
    Serializable {
        private static final long serialVersionUID = -4812427470992224532L;
        private final Problem problem;
        private final Solution solution;

        public ProblemEvaluator(Problem problem, Solution solution) {
            this.problem = problem;
            this.solution = solution;
        }

        @Override
        public Solution call() throws Exception {
            this.problem.evaluate(this.solution);
            return this.solution;
        }
    }
}

