/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.grammar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.moeaframework.util.grammar.GrammarException;
import org.moeaframework.util.grammar.Production;
import org.moeaframework.util.grammar.Rule;
import org.moeaframework.util.grammar.Symbol;

public class ContextFreeGrammar {
    private final List<Rule> rules = new ArrayList<Rule>();
    private int wrapLimit = 10;

    public int getWrapLimit() {
        return this.wrapLimit;
    }

    public void setWrapLimit(int wrapLimit) {
        this.wrapLimit = wrapLimit;
    }

    public void add(Rule rule) {
        this.rules.add(rule);
    }

    public void remove(Rule rule) {
        this.rules.remove(rule);
    }

    public int size() {
        return this.rules.size();
    }

    public Rule get(int index) {
        return this.rules.get(index);
    }

    public Rule get(Symbol symbol) {
        for (Rule rule : this.rules) {
            if (!rule.getSymbol().equals(symbol)) continue;
            return rule;
        }
        return null;
    }

    public String build(int[] array) {
        if (array.length == 0) {
            throw new GrammarException("codon array is empty");
        }
        StringBuilder sb = new StringBuilder();
        Stack<Symbol> remaining = new Stack<Symbol>();
        int index = 0;
        int wraps = 0;
        remaining.push(this.rules.get(0).getSymbol());
        while (!remaining.isEmpty()) {
            Symbol symbol = (Symbol)remaining.pop();
            if (symbol.isTerminal()) {
                sb.append(symbol.getValue());
                continue;
            }
            Rule rule = this.get(symbol);
            int productionIndex = 0;
            if (rule.size() > 1) {
                productionIndex = array[index] % rule.size();
                if (++index >= array.length) {
                    index = 0;
                    if (++wraps > this.wrapLimit) {
                        return null;
                    }
                }
            }
            Production production = rule.get(productionIndex);
            for (int i = production.size() - 1; i >= 0; --i) {
                remaining.push(production.get(i));
            }
        }
        return sb.toString();
    }

    public boolean isValid() {
        if (this.size() == 0) {
            return false;
        }
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        for (int i = 0; i < this.size(); ++i) {
            Rule rule = this.get(i);
            for (int j = 0; j < rule.size(); ++j) {
                Production production = rule.get(j);
                for (int k = 0; k < production.size(); ++k) {
                    Symbol symbol = production.get(k);
                    if (symbol.isTerminal()) continue;
                    symbols.add(symbol);
                }
            }
        }
        for (Symbol symbol : symbols) {
            if (this.get(symbol) != null) continue;
            return false;
        }
        return true;
    }
}

