/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Settings;
import org.moeaframework.util.CommandLineUtility;
import org.moeaframework.util.io.ValidationException;

public class FileProtection
extends CommandLineUtility {
    public static final String STRICT_MODE = "STRICT";
    public static final String SAFE_MODE = "SAFE";

    private FileProtection() {
    }

    private static MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new FrameworkException(e);
        }
    }

    public static File getDigestFile(File file) {
        return new File(file.getParentFile(), MessageFormat.format(Settings.getFileProtectionFormat(), file.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDigest(File file, byte[] digest) throws IOException {
        PrintStream ps = null;
        try {
            ps = new PrintStream(FileProtection.getDigestFile(file));
            ps.print(Hex.encodeHex((byte[])digest));
            ps.print("  ");
            ps.print(file.getPath());
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static byte[] loadDigest(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(FileProtection.getDigestFile(file)));
            String line = reader.readLine();
            if (line == null) {
                throw new ValidationException(file, "invalid digest file");
            }
            int split = line.indexOf(32);
            String digestHex = line.substring(0, split);
            String fileName = line.substring(split + 2);
            if (!file.getPath().equals(fileName)) {
                throw new ValidationException(file, "invalid digest file");
            }
            byte[] byArray = Hex.decodeHex((char[])digestHex.toCharArray());
            return byArray;
        }
        catch (Exception e) {
            throw new ValidationException(file, "invalid digest file");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] computeDigest(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] byArray = DigestUtils.md5((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static Reader openReader(File file) throws FileNotFoundException {
        return new InputStreamReader(FileProtection.openInputStream(file));
    }

    public static InputStream openInputStream(final File file) throws FileNotFoundException {
        return new DigestInputStream(new FileInputStream(file), FileProtection.createMessageDigest()){

            @Override
            public void close() throws IOException {
                byte[] buffer = new byte[4096];
                while (this.read(buffer) != -1) {
                }
                super.close();
                FileProtection.validate(file, this.getMessageDigest().digest());
            }
        };
    }

    public static Writer openWriter(File file) throws FileNotFoundException {
        return new OutputStreamWriter(FileProtection.openOutputStream(file));
    }

    private static void validate(File file, byte[] actual) throws IOException {
        String mode = Settings.getFileProtectionMode();
        File digestFile = FileProtection.getDigestFile(file);
        if (digestFile.exists()) {
            byte[] expected = FileProtection.loadDigest(file);
            if (!MessageDigest.isEqual(actual, expected)) {
                throw new ValidationException(file, "digest does not match");
            }
        } else {
            if (mode.equalsIgnoreCase(STRICT_MODE)) {
                throw new ValidationException(file, "no digest file");
            }
            System.err.println("no digest file exists to validate " + file);
        }
    }

    public static void validate(File file) throws IOException {
        FileProtection.validate(file, FileProtection.computeDigest(file));
    }

    public static OutputStream openOutputStream(final File file) throws FileNotFoundException {
        return new DigestOutputStream(new FileOutputStream(file), FileProtection.createMessageDigest()){

            @Override
            public void close() throws IOException {
                super.close();
                FileProtection.saveDigest(file, this.getMessageDigest().digest());
            }
        };
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"check");
        OptionBuilder.withDescription((String)"Validates the listed files");
        options.addOption(OptionBuilder.create((char)'c'));
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption("check")) {
            int validCount = 0;
            int invalidCount = 0;
            String mode = Settings.getFileProtectionMode();
            for (String filename : commandLine.getArgs()) {
                File file = new File(filename);
                System.out.print(file);
                System.out.print(": ");
                if (FileProtection.getDigestFile(file).exists()) {
                    byte[] expected;
                    byte[] actual = FileProtection.computeDigest(file);
                    boolean valid = MessageDigest.isEqual(actual, expected = FileProtection.loadDigest(file));
                    if (valid) {
                        ++validCount;
                        System.out.println("OK");
                        continue;
                    }
                    ++invalidCount;
                    System.out.println("FAILED");
                    continue;
                }
                if (mode.equalsIgnoreCase(STRICT_MODE)) {
                    ++invalidCount;
                    System.out.println("FAILED");
                    continue;
                }
                ++validCount;
                System.out.println("OK (NO DIGEST FILE)");
            }
            if (invalidCount > 0) {
                System.err.print("WARNING: ");
                System.err.print(invalidCount);
                System.err.print(" of ");
                System.err.print(validCount + invalidCount);
                System.err.println(" computed checksums did NOT match");
            }
        } else {
            for (String filename : commandLine.getArgs()) {
                File file = new File(filename);
                byte[] digest = FileProtection.computeDigest(file);
                FileProtection.saveDigest(file, digest);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new FileProtection().start(args);
    }
}

