/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;

public class FileUtils {
    private static final String UNABLE_TO_DELETE = "unable to delete {0}";
    private static final String UNABLE_TO_MKDIR = "unable to mkdir {0}";

    private FileUtils() {
    }

    public static void move(File source, File destination) throws IOException {
        Validate.notNull((Object)source, (String)"source is null", (Object[])new Object[0]);
        Validate.notNull((Object)destination, (String)"destination is null", (Object[])new Object[0]);
        if (source.equals(destination)) {
            return;
        }
        if (!source.renameTo(destination)) {
            FileUtils.copy(source, destination);
            if (!source.delete()) {
                if (!destination.delete()) {
                    throw new IOException(MessageFormat.format(UNABLE_TO_DELETE, destination));
                }
                throw new IOException(MessageFormat.format(UNABLE_TO_DELETE, source));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File destination) throws IOException {
        Validate.notNull((Object)source, (String)"source is null", (Object[])new Object[0]);
        Validate.notNull((Object)destination, (String)"destination is null", (Object[])new Object[0]);
        if (source.equals(destination)) {
            return;
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(source);
            try {
                output = new FileOutputStream(destination);
                FileUtils.copy(input, output);
            }
            finally {
                if (output != null) {
                    ((OutputStream)output).close();
                }
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static void delete(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException(MessageFormat.format(UNABLE_TO_DELETE, file));
        }
    }

    public static void mkdir(File directory) throws IOException {
        if (directory.exists() ? !directory.isDirectory() : !directory.mkdirs()) {
            throw new IOException(MessageFormat.format(UNABLE_TO_MKDIR, directory));
        }
    }
}

