/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.progress;

import org.apache.commons.lang3.event.EventListenerSupport;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.moeaframework.Executor;
import org.moeaframework.util.progress.ProgressEvent;
import org.moeaframework.util.progress.ProgressListener;

public class ProgressHelper {
    private final EventListenerSupport<ProgressListener> listeners;
    private final DescriptiveStatistics statistics;
    private final Executor executor;
    private int currentSeed;
    private int totalSeeds;
    private int currentNFE;
    private int maxNFE;
    private long startTime;
    private long lastTime;
    private long maxTime;
    private int lastSeed;
    private int lastNFE;

    public ProgressHelper(Executor executor) {
        this.executor = executor;
        this.statistics = new DescriptiveStatistics(25);
        this.listeners = EventListenerSupport.create(ProgressListener.class);
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void updateStatistics() {
        long currentTime = System.currentTimeMillis();
        double diffTime = currentTime - this.lastTime;
        double diffSeed = this.currentSeed - this.lastSeed;
        double diffNFE = this.currentNFE - this.lastNFE;
        double percentNFE = Double.POSITIVE_INFINITY;
        double percentTime = Double.POSITIVE_INFINITY;
        if (this.maxNFE >= 0) {
            percentNFE = diffNFE / (double)this.maxNFE;
        }
        if (this.maxTime >= 0L) {
            percentTime = diffTime / (double)this.maxTime;
        }
        double diffPercent = Math.min(percentNFE, percentTime);
        double percentChange = (diffSeed + diffPercent) / (double)this.totalSeeds;
        if (diffTime > 0.0 && percentChange > 1.0E-4) {
            this.statistics.addValue(diffTime / percentChange);
            this.lastTime = currentTime;
            this.lastSeed = this.currentSeed;
            this.lastNFE = this.currentNFE;
        }
    }

    private void sendProgressEvent(boolean isSeedFinished) {
        long currentTime = System.currentTimeMillis();
        double remainingSeeds = this.totalSeeds - this.currentSeed;
        double remainingNFE = this.maxNFE - this.currentNFE;
        double remainingTime = this.maxTime - (currentTime - this.startTime);
        double percentNFE = Double.POSITIVE_INFINITY;
        double percentTime = Double.POSITIVE_INFINITY;
        if (this.maxNFE >= 0) {
            percentNFE = (remainingSeeds + remainingNFE / (double)this.maxNFE) / (double)this.totalSeeds;
        }
        if (this.maxTime >= 0L) {
            percentTime = (remainingSeeds + remainingTime / (double)this.maxTime) / (double)this.totalSeeds;
        }
        double percentRemaining = Math.min(percentNFE, percentTime);
        ProgressEvent event = new ProgressEvent(this.executor, this.currentSeed, this.totalSeeds, isSeedFinished, this.currentNFE, this.maxNFE, Math.max(1.0 - percentRemaining, 0.0), (double)(currentTime - this.startTime) / 1000.0, this.statistics.getMean() * percentRemaining / 1000.0, (double)this.maxTime / 1000.0);
        ((ProgressListener)this.listeners.fire()).progressUpdate(event);
    }

    public void setCurrentNFE(int currentNFE) {
        this.currentNFE = currentNFE;
        this.updateStatistics();
        this.sendProgressEvent(false);
    }

    public void setCurrentSeed(int currentSeed) {
        if (this.currentSeed != currentSeed) {
            this.currentSeed = currentSeed;
            this.updateStatistics();
            this.sendProgressEvent(true);
        }
    }

    public void nextSeed() {
        ++this.currentSeed;
        this.currentNFE = 0;
        this.updateStatistics();
        this.sendProgressEvent(true);
    }

    public void start(int totalSeeds, int maxNFE, long maxTime) {
        this.totalSeeds = totalSeeds;
        this.maxNFE = maxNFE;
        this.maxTime = maxTime;
        this.lastSeed = 1;
        this.lastNFE = 0;
        this.currentSeed = 1;
        this.currentNFE = 0;
        this.statistics.clear();
        this.lastTime = this.startTime = System.currentTimeMillis();
    }

    public void stop() {
    }
}

