/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.sequence;

import org.moeaframework.util.sequence.Sequence;
import org.moeaframework.util.sequence.Sobol;

public class Saltelli
implements Sequence {
    private final Sobol sobol = new Sobol();

    @Override
    public double[][] generate(int N, int D) {
        if (N % (2 * D + 2) != 0) {
            throw new IllegalArgumentException("N must be a multiple of 2*D+2");
        }
        double[][] sobolSequence = this.sobol.generate((N /= 2 * D + 2) + 1000, 2 * D);
        double[][] saltelliSequence = new double[(2 * D + 2) * N][D];
        int index = 0;
        for (int i = 1000; i < N + 1000; ++i) {
            int j;
            int k;
            int j2;
            for (j2 = 0; j2 < D; ++j2) {
                saltelliSequence[index][j2] = sobolSequence[i][j2];
            }
            ++index;
            for (k = 0; k < D; ++k) {
                for (j = 0; j < D; ++j) {
                    saltelliSequence[index][j] = j == k ? sobolSequence[i][j + D] : sobolSequence[i][j];
                }
                ++index;
            }
            for (k = 0; k < D; ++k) {
                for (j = 0; j < D; ++j) {
                    saltelliSequence[index][j] = j == k ? sobolSequence[i][j] : sobolSequence[i][j + D];
                }
                ++index;
            }
            for (j2 = 0; j2 < D; ++j2) {
                saltelliSequence[index][j2] = sobolSequence[i][j2 + D];
            }
            ++index;
        }
        return saltelliSequence;
    }
}

