/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.sequence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.util.sequence.Sequence;

public class Sobol
implements Sequence {
    private static final int scale = 31;
    private static int[][] DIRECTIONS;
    private static final String DIRECTIONS_RESOURCE = "joe-kuo-6.21000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDirectionNumbers() throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(Sobol.class.getResourceAsStream(DIRECTIONS_RESOURCE)));
            ArrayList<int[]> directions = new ArrayList<int[]>();
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                tokenizer.nextToken();
                int s = Integer.parseInt(tokenizer.nextToken());
                int[] d = new int[s + 1];
                d[0] = Integer.parseInt(tokenizer.nextToken());
                for (int i = 1; i <= s; ++i) {
                    d[i] = Integer.parseInt(tokenizer.nextToken());
                }
                directions.add(d);
            }
            DIRECTIONS = (int[][])directions.toArray((T[])new int[0][0]);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static int indexOfLeastSignificantZeroBit(int value) {
        int index = 1;
        while ((value & 1) != 0) {
            value >>= 1;
            ++index;
        }
        return index;
    }

    @Override
    public double[][] generate(int N, int D) {
        if (D > DIRECTIONS.length + 1) {
            throw new FrameworkException("not enough dimensions");
        }
        int L = (int)Math.ceil(Math.log(N) / Math.log(2.0));
        if (L > 31) {
            throw new FrameworkException("not enough bits");
        }
        double[][] points = new double[N][D];
        for (int i = 0; i < D; ++i) {
            long[] V = new long[L + 1];
            if (i == 0) {
                for (int j = 1; j <= L; ++j) {
                    V[j] = 1 << 31 - j;
                }
            } else {
                int j;
                int[] m = DIRECTIONS[i - 1];
                int a = m[0];
                int s = m.length - 1;
                if (L <= s) {
                    for (j = 1; j <= L; ++j) {
                        V[j] = m[j] << 31 - j;
                    }
                } else {
                    for (j = 1; j <= s; ++j) {
                        V[j] = m[j] << 31 - j;
                    }
                    for (j = s + 1; j <= L; ++j) {
                        V[j] = V[j - s] ^ V[j - s] >> s;
                        for (int k = 1; k < s; ++k) {
                            int n = j;
                            V[n] = V[n] ^ (long)(a >> s - 1 - k & 1) * V[j - k];
                        }
                    }
                }
            }
            long X = 0L;
            for (int j = 1; j < N; ++j) {
                points[j][i] = (double)(X ^= V[Sobol.indexOfLeastSignificantZeroBit(j - 1)]) / Math.pow(2.0, 31.0);
            }
        }
        return points;
    }

    static {
        try {
            Sobol.loadDirectionNumbers();
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
    }
}

