/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.statistics;

import java.util.ArrayList;
import java.util.List;
import org.moeaframework.util.statistics.Observation;
import org.moeaframework.util.statistics.StatisticalTest;

public abstract class IntervalRatioStatisticalTest
implements StatisticalTest {
    protected final int numberOfGroups;
    protected final List<Observation> data;

    public IntervalRatioStatisticalTest(int numberOfGroups) {
        this.numberOfGroups = numberOfGroups;
        this.data = new ArrayList<Observation>();
    }

    protected void add(double value, int group) {
        if (group < 0 || group >= this.numberOfGroups) {
            throw new IllegalArgumentException("invalid group");
        }
        this.data.add(new Observation(value, group));
    }

    protected void addAll(double[] values, int group) {
        for (double value : values) {
            this.add(value, group);
        }
    }

    protected List<double[]> categorize() {
        int[] n = new int[this.numberOfGroups];
        for (Observation observation : this.data) {
            int n2 = observation.getGroup();
            n[n2] = n[n2] + 1;
        }
        ArrayList<double[]> groupedData = new ArrayList<double[]>();
        for (int i = 0; i < this.numberOfGroups; ++i) {
            groupedData.add(new double[n[i]]);
        }
        for (Observation observation : this.data) {
            int group;
            int n3 = group = observation.getGroup();
            n[n3] = n[n3] - 1;
            ((double[])groupedData.get((int)group))[n[group]] = observation.getValue();
        }
        return groupedData;
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }
}

