/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.statistics;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.moeaframework.util.statistics.OrdinalStatisticalTest;
import org.moeaframework.util.statistics.RankedObservation;

public class KruskalWallisTest
extends OrdinalStatisticalTest {
    public KruskalWallisTest(int numberOfGroups) {
        super(numberOfGroups);
        if (numberOfGroups <= 1) {
            throw new IllegalArgumentException("requires two or more groups");
        }
    }

    @Override
    public void add(double value, int group) {
        super.add(value, group);
    }

    @Override
    public void addAll(double[] values, int group) {
        super.addAll(values, group);
    }

    double H() {
        int[] n = new int[this.numberOfGroups];
        double[] rbar = new double[this.numberOfGroups];
        for (RankedObservation observation : this.data) {
            int n2 = observation.getGroup();
            n[n2] = n[n2] + 1;
            int n3 = observation.getGroup();
            rbar[n3] = rbar[n3] + observation.getRank();
        }
        double H = 0.0;
        for (int i = 0; i < this.numberOfGroups; ++i) {
            H += Math.pow(rbar[i], 2.0) / (double)n[i];
        }
        int N = this.data.size();
        return 12.0 / (double)(N * (N + 1)) * H - 3.0 * (double)(N + 1);
    }

    double C() {
        int N = this.data.size();
        double C = 0.0;
        int i = 0;
        while (i < N) {
            int j;
            for (j = i + 1; j < N && ((RankedObservation)this.data.get(i)).getValue() == ((RankedObservation)this.data.get(j)).getValue(); ++j) {
            }
            C += Math.pow(j - i, 3.0) - (double)(j - i);
            i = j;
        }
        return 1.0 - C / (Math.pow(N, 3.0) - (double)N);
    }

    @Override
    public boolean test(double alpha) {
        this.update();
        ChiSquaredDistribution dist = new ChiSquaredDistribution((double)(this.numberOfGroups - 1));
        double H = this.H();
        double C = this.C();
        if (C == 0.0) {
            return false;
        }
        return 1.0 - dist.cumulativeProbability(H / C) < alpha;
    }
}

