/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.statistics;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.moeaframework.core.Settings;
import org.moeaframework.util.statistics.OrdinalStatisticalTest;
import org.moeaframework.util.statistics.RankedObservation;

public class MannWhitneyUTest
extends OrdinalStatisticalTest {
    double lastU;
    private static final int[] TABLE_5 = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, -1, -1, -1, -1, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, -1, -1, -1, 0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 13, -1, -1, 0, 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 17, 18, 19, 20, -1, -1, 1, 2, 3, 5, 6, 8, 10, 11, 13, 14, 16, 17, 19, 21, 22, 24, 25, 27, -1, -1, 1, 3, 5, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, -1, 0, 2, 4, 6, 8, 10, 13, 15, 17, 19, 22, 24, 26, 29, 31, 34, 36, 38, 41, -1, 0, 2, 4, 7, 10, 12, 15, 17, 21, 23, 26, 28, 31, 34, 37, 39, 42, 45, 48, -1, 0, 3, 5, 8, 11, 14, 17, 20, 23, 26, 29, 33, 36, 39, 42, 45, 48, 52, 55, -1, 0, 3, 6, 9, 13, 16, 19, 23, 26, 30, 33, 37, 40, 44, 47, 51, 55, 58, 62, -1, 1, 4, 7, 11, 14, 18, 22, 26, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, -1, 1, 4, 8, 12, 16, 20, 24, 28, 33, 37, 41, 45, 50, 54, 59, 63, 67, 72, 76, -1, 1, 5, 9, 13, 17, 22, 26, 31, 36, 40, 45, 50, 55, 59, 64, 67, 74, 78, 83, -1, 1, 5, 10, 14, 19, 24, 29, 34, 39, 44, 49, 54, 59, 64, 70, 75, 80, 85, 90, -1, 1, 6, 11, 15, 21, 26, 31, 37, 42, 47, 53, 59, 64, 70, 75, 81, 86, 92, 98, -1, 2, 6, 11, 17, 22, 28, 34, 39, 45, 51, 57, 63, 67, 75, 81, 87, 93, 99, 105, -1, 2, 7, 12, 18, 24, 30, 36, 42, 48, 55, 61, 67, 74, 80, 86, 93, 99, 106, 112, -1, 2, 7, 13, 19, 25, 32, 38, 45, 52, 58, 65, 72, 78, 85, 92, 99, 106, 113, 119, -1, 2, 8, 14, 20, 27, 34, 41, 48, 55, 62, 69, 76, 83, 90, 98, 105, 112, 119, 127};
    private static final int[] TABLE_1 = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2, 3, 3, -1, -1, -1, -1, -1, 0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, -1, -1, -1, -1, 0, 1, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 15, 16, 17, 18, -1, -1, -1, 0, 1, 3, 4, 6, 7, 9, 10, 12, 13, 15, 16, 18, 19, 21, 22, 24, -1, -1, -1, 1, 2, 4, 6, 7, 9, 11, 13, 15, 17, 18, 20, 22, 24, 26, 28, 30, -1, -1, 0, 1, 3, 5, 7, 9, 11, 13, 16, 18, 20, 22, 24, 27, 29, 31, 33, 36, -1, -1, 0, 2, 4, 6, 9, 11, 13, 16, 18, 21, 24, 26, 29, 31, 34, 37, 39, 42, -1, -1, 0, 2, 5, 7, 10, 13, 16, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 46, -1, -1, 1, 3, 6, 9, 12, 15, 18, 21, 24, 27, 31, 34, 37, 41, 44, 47, 51, 54, -1, -1, 1, 3, 7, 10, 13, 17, 20, 24, 27, 31, 34, 38, 42, 45, 49, 53, 56, 60, -1, -1, 1, 4, 7, 11, 15, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 63, 67, -1, -1, 2, 5, 8, 12, 16, 20, 24, 29, 33, 37, 42, 46, 51, 55, 60, 64, 69, 73, -1, -1, 2, 5, 9, 13, 18, 22, 27, 31, 36, 41, 45, 50, 55, 60, 65, 70, 74, 79, -1, -1, 2, 6, 10, 15, 19, 24, 29, 34, 39, 44, 49, 54, 60, 65, 70, 75, 81, 86, -1, -1, 2, 6, 11, 16, 21, 26, 31, 37, 42, 47, 53, 58, 64, 70, 75, 81, 87, 92, -1, 0, 3, 7, 12, 17, 22, 28, 33, 39, 45, 51, 56, 63, 69, 74, 81, 87, 93, 99, -1, 0, 3, 8, 13, 18, 24, 30, 36, 42, 46, 54, 60, 67, 73, 79, 86, 92, 99, 105};

    public MannWhitneyUTest() {
        super(2);
    }

    @Override
    public void add(double value, int group) {
        super.add(value, group);
    }

    @Override
    public void addAll(double[] values, int group) {
        super.addAll(values, group);
    }

    @Override
    public boolean test(double alpha) {
        double U;
        double[] R = new double[2];
        int[] n = new int[2];
        this.update();
        for (RankedObservation observation : this.data) {
            int n2 = observation.getGroup();
            n[n2] = n[n2] + 1;
            int n3 = observation.getGroup();
            R[n3] = R[n3] + observation.getRank();
        }
        double U1 = (double)(n[0] * n[1]) + (double)(n[0] * (n[0] + 1)) / 2.0 - R[0];
        double U2 = (double)(n[0] * n[1]) + (double)(n[1] * (n[1] + 1)) / 2.0 - R[1];
        this.lastU = U = Math.min(U1, U2);
        if (n[0] <= 20 && n[1] <= 20) {
            return U <= (double)MannWhitneyUTest.getCriticalUValueFromTable(n[0], n[1], alpha);
        }
        double z = 0.0;
        NormalDistribution dist = new NormalDistribution();
        z = Settings.isContinuityCorrection() ? (Math.abs(U - (double)(n[0] * n[1]) / 2.0) - 0.5) / Math.sqrt((double)(n[0] * n[1]) * ((double)(n[0] + n[1]) + 1.0) / 12.0) : (U - (double)(n[0] * n[1]) / 2.0) / Math.sqrt((double)(n[0] * n[1]) * ((double)(n[0] + n[1]) + 1.0) / 12.0);
        return Math.abs(z) >= Math.abs(dist.inverseCumulativeProbability(alpha));
    }

    private static int getCriticalUValueFromTable(int n1, int n2, double alpha) {
        if (n1 < 1 || n1 > 20 || n2 < 1 || n2 > 20) {
            throw new IllegalArgumentException("only valid for 1 <= n1 <= 20, 1 <= n2 <= 20");
        }
        int value = -1;
        if (alpha == 0.05) {
            value = TABLE_5[20 * n1 + n2 - 21];
        } else if (alpha == 0.01) {
            value = TABLE_1[20 * n1 + n2 - 21];
        } else {
            throw new IllegalArgumentException("only valid for 0.05 or 0.01");
        }
        if (value == -1) {
            throw new IllegalArgumentException("insufficient sampling size");
        }
        return value;
    }
}

