/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.moeaframework.util.statistics.RankedObservation;
import org.moeaframework.util.statistics.StatisticalTest;

public abstract class OrdinalStatisticalTest
implements StatisticalTest {
    protected final int numberOfGroups;
    protected final Comparator<RankedObservation> comparator;
    protected final List<RankedObservation> data;

    public OrdinalStatisticalTest(int numberOfGroups) {
        this(numberOfGroups, new ObservationComparator());
    }

    public OrdinalStatisticalTest(int numberOfGroups, Comparator<RankedObservation> comparator) {
        this.numberOfGroups = numberOfGroups;
        this.comparator = comparator;
        this.data = new ArrayList<RankedObservation>();
    }

    protected void add(double value, int group) {
        if (group < 0 || group >= this.numberOfGroups) {
            throw new IllegalArgumentException();
        }
        this.data.add(new RankedObservation(value, group));
    }

    protected void addAll(double[] values, int group) {
        for (double value : values) {
            this.add(value, group);
        }
    }

    protected void update() {
        Collections.sort(this.data, this.comparator);
        int i = 0;
        while (i < this.data.size()) {
            int j;
            double rank = i + 1;
            for (j = i + 1; j < this.data.size() && this.data.get(i).getValue() == this.data.get(j).getValue(); ++j) {
                rank += (double)(j + 1);
            }
            rank /= (double)(j - i);
            for (int k = i; k < j; ++k) {
                this.data.get(k).setRank(rank);
            }
            i = j;
        }
    }

    public int size() {
        return this.data.size();
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public Comparator<RankedObservation> getComparator() {
        return this.comparator;
    }

    private static class ObservationComparator
    implements Comparator<RankedObservation>,
    Serializable {
        private static final long serialVersionUID = 284381611483212771L;

        private ObservationComparator() {
        }

        @Override
        public int compare(RankedObservation o1, RankedObservation o2) {
            if (o1.getValue() < o2.getValue()) {
                return -1;
            }
            if (o1.getValue() > o2.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

