/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.statistics;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.moeaframework.core.Settings;
import org.moeaframework.util.statistics.OrdinalStatisticalTest;
import org.moeaframework.util.statistics.RankedObservation;

public class WilcoxonSignedRanksTest
extends OrdinalStatisticalTest {
    private final double median;
    double lastT;
    private static final int[] TABLE_5 = new int[]{0, 2, 3, 5, 8, 10, 13, 17, 21, 25, 29, 34, 40, 46, 52, 58, 65, 73, 81, 89, 98, 107, 116, 126, 137, 147, 159, 170, 182, 195, 208, 221, 235, 249, 264, 279, 294, 310, 327, 343, 361, 378, 396, 415, 434};
    private static final int[] TABLE_1 = new int[]{-1, -1, 0, 1, 3, 5, 7, 9, 12, 15, 19, 23, 27, 32, 37, 42, 48, 54, 61, 68, 75, 83, 91, 100, 109, 118, 128, 138, 148, 159, 171, 182, 194, 207, 220, 233, 247, 261, 276, 291, 307, 322, 339, 355, 373};

    public WilcoxonSignedRanksTest(double median) {
        super(1, new AbsoluteObservationComparator());
        this.median = median;
    }

    public double getMedian() {
        return this.median;
    }

    public void add(double value) {
        if (value - this.median != 0.0) {
            super.add(value - this.median, 0);
        }
    }

    public void add(double[] values) {
        for (double value : values) {
            this.add(value);
        }
    }

    @Override
    public boolean test(double alpha) {
        double T;
        double Rpos = 0.0;
        double Rneg = 0.0;
        this.update();
        for (RankedObservation observation : this.data) {
            if (observation.getValue() < 0.0) {
                Rneg += observation.getRank();
                continue;
            }
            Rpos += observation.getRank();
        }
        int n = this.data.size();
        this.lastT = T = Math.min(Rpos, Rneg);
        if (n <= 50) {
            return T <= (double)WilcoxonSignedRanksTest.getCriticalTValueFromTable(n, alpha);
        }
        double z = 0.0;
        NormalDistribution dist = new NormalDistribution();
        z = Settings.isContinuityCorrection() ? (Math.abs(T - (double)(n * (n + 1)) / 4.0) - 0.5) / Math.sqrt((double)(n * (n + 1) * (n + n + 1)) / 24.0) : (T - (double)(n * (n + 1)) / 4.0) / Math.sqrt((double)(n * (n + 1) * (n + n + 1)) / 24.0);
        return Math.abs(z) >= Math.abs(dist.inverseCumulativeProbability(alpha));
    }

    private static int getCriticalTValueFromTable(int n, double alpha) {
        if (n < 6 || n > 50) {
            throw new IllegalArgumentException("only valid for 6 <= n <= 50");
        }
        int value = -1;
        if (alpha == 0.05) {
            value = TABLE_5[n - 6];
        } else if (alpha == 0.01) {
            value = TABLE_1[n - 6];
        } else {
            throw new IllegalArgumentException("only valid for 0.05 or 0.01");
        }
        if (value == -1) {
            throw new IllegalArgumentException("insufficient sampling size");
        }
        return value;
    }

    private static class AbsoluteObservationComparator
    implements Comparator<RankedObservation>,
    Serializable {
        private static final long serialVersionUID = 7337112773629454794L;

        private AbsoluteObservationComparator() {
        }

        @Override
        public int compare(RankedObservation o1, RankedObservation o2) {
            double v2;
            double v1 = Math.abs(o1.getValue());
            if (v1 < (v2 = Math.abs(o2.getValue()))) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }
}

