/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import org.moeaframework.util.tree.Define;
import org.moeaframework.util.tree.Environment;
import org.moeaframework.util.tree.Node;

public class Call
extends Node {
    private final String functionName;
    private final String[] variableNames;
    private final Class<?>[] variableTypes;

    public Call(String functionName, Class<?> returnType) {
        this(functionName, returnType, new String[0], new Class[0]);
    }

    public Call(String functionName, Class<?> returnType, String variableName, Class<?> variableType) {
        this(functionName, returnType, new String[]{variableName}, new Class[]{variableType});
    }

    public Call(String functionName, Class<?> returnType, String name1, Class<?> type1, String name2, Class<?> type2) {
        this(functionName, returnType, new String[]{name1, name2}, new Class[]{type1, type2});
    }

    public Call(Define function) {
        this(function.getFunctionName(), function.getArgumentType(0), function.getVariableNames(), function.getVariableTypes());
    }

    public Call(String functionName, Class<?> returnType, String[] variableNames, Class<?>[] variableTypes) {
        super(returnType, variableTypes);
        this.functionName = functionName;
        this.variableNames = variableNames;
        this.variableTypes = variableTypes;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public Class<?>[] getVariableTypes() {
        return this.variableTypes;
    }

    @Override
    public Node copyNode() {
        return new Call(this.functionName, this.getReturnType(), this.variableNames, this.variableTypes);
    }

    @Override
    public Object evaluate(Environment environment) {
        Environment closure = new Environment(environment);
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            closure.set(this.variableNames[i], this.getArgument(i).evaluate(environment));
        }
        Node functionBody = environment.get(Node.class, this.functionName);
        return functionBody.evaluate(closure);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.getClass().getSimpleName());
        sb.append(' ');
        sb.append(this.getFunctionName());
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            sb.append(' ');
            sb.append(this.getArgument(0).toString());
        }
        sb.append(')');
        return sb.toString();
    }
}

