/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import org.moeaframework.util.tree.Environment;
import org.moeaframework.util.tree.Node;

public class Define
extends Node {
    private final String functionName;
    private final String[] variableNames;
    private final Class<?>[] variableTypes;

    public Define(String functionName, Class<?> returnType) {
        this(functionName, returnType, new String[0], new Class[0]);
    }

    public Define(String functionName, Class<?> returnType, String variableName, Class<?> variableType) {
        this(functionName, returnType, new String[]{variableName}, new Class[]{variableType});
    }

    public Define(String functionName, Class<?> returnType, String name1, Class<?> type1, String name2, Class<?> type2) {
        this(functionName, returnType, new String[]{name1, name2}, new Class[]{type1, type2});
    }

    public Define(String functionName, Class<?> returnType, String[] variableNames, Class<?>[] variableTypes) {
        super(Void.class, returnType);
        this.functionName = functionName;
        this.variableNames = variableNames;
        this.variableTypes = variableTypes;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public Class<?>[] getVariableTypes() {
        return this.variableTypes;
    }

    @Override
    public Node copyNode() {
        return new Define(this.functionName, this.getArgumentType(0), this.variableNames, this.variableTypes);
    }

    @Override
    public Void evaluate(Environment environment) {
        environment.set(this.functionName, this.getArgument(0));
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.getClass().getSimpleName());
        sb.append(' ');
        sb.append(this.getFunctionName());
        sb.append(" (");
        for (int i = 0; i < this.variableNames.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.variableNames[i]);
        }
        sb.append(") ");
        sb.append(this.getArgument(0).toString());
        sb.append(')');
        return sb.toString();
    }
}

