/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import org.moeaframework.util.tree.Environment;
import org.moeaframework.util.tree.Node;

public class Lambda
extends Node {
    private final Node node;
    private final String[] variableNames;

    public Lambda(Node node) {
        this(node, new String[0], new Class[0]);
    }

    public Lambda(Node node, String variableName, Class<?> variableType) {
        this(node, new String[]{variableName}, new Class[]{variableType});
    }

    public Lambda(Node node, String name1, Class<?> type1, String name2, Class<?> type2) {
        this(node, new String[]{name1, name2}, new Class[]{type1, type2});
    }

    public Lambda(Node node, String[] variableNames, Class<?>[] variableTypes) {
        super(node.getReturnType(), variableTypes);
        this.node = node;
        this.variableNames = variableNames;
        if (!node.isValid()) {
            throw new IllegalArgumentException("lambda function is not valid");
        }
    }

    @Override
    public Node copyNode() {
        return new Lambda(this.node.copyTree(), this.variableNames, this.getArgumentTypes());
    }

    @Override
    public Object evaluate(Environment environment) {
        Environment closure = new Environment(environment);
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            closure.set(this.variableNames[i], this.getArgument(i).evaluate(environment));
        }
        return this.node.evaluate(closure);
    }
}

