/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import org.moeaframework.util.tree.Environment;

public abstract class Node {
    private boolean fixed;
    private Node parent;
    private final Node[] arguments;
    private final Class<?> returnType;
    private final Class<?>[] argumentTypes;

    public Node() {
        this(Void.class, new Class[0]);
    }

    public Node(Class<?> returnType, Class<?> ... argumentTypes) {
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.arguments = new Node[argumentTypes.length];
    }

    public void setFixedTree(boolean fixed) {
        this.setFixed(fixed);
        for (Node argument : this.arguments) {
            if (argument == null) continue;
            argument.setFixedTree(fixed);
        }
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public int getNumberOfArguments() {
        return this.argumentTypes.length;
    }

    public Node getArgument(int index) {
        return this.arguments[index];
    }

    public Node getParent() {
        return this.parent;
    }

    void setParent(Node parent) {
        this.parent = parent;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?> getArgumentType(int index) {
        return this.argumentTypes[index];
    }

    public Node setArgument(int index, Node expression) {
        expression.setParent(this);
        this.arguments[index] = expression;
        return this;
    }

    public int size() {
        int size = 0;
        for (Node argument : this.arguments) {
            size += argument.size();
        }
        return size + 1;
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public int getMinimumHeight() {
        if (this.arguments.length == 0) {
            return 0;
        }
        int height = Integer.MAX_VALUE;
        for (Node argument : this.arguments) {
            height = Math.min(height, argument.getMinimumHeight());
        }
        return height + 1;
    }

    public int getMaximumHeight() {
        if (this.arguments.length == 0) {
            return 0;
        }
        int height = 0;
        for (Node argument : this.arguments) {
            height = Math.max(height, argument.getMaximumHeight());
        }
        return height + 1;
    }

    public abstract Node copyNode();

    public Node copyTree() {
        Node node = this.copyNode();
        node.setFixed(this.isFixed());
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            if (this.getArgument(i) == null) continue;
            node.setArgument(i, this.getArgument(i).copyTree());
        }
        return node;
    }

    public abstract Object evaluate(Environment var1);

    public boolean isValid() {
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            Node argument = this.getArgument(i);
            if (argument == null) {
                System.err.println("argument is null");
                return false;
            }
            if (!this.getArgumentType(i).isAssignableFrom(argument.getReturnType())) {
                System.err.println(this.getClass().getSimpleName() + " (" + i + "): " + this.getArgumentType(i) + " not assignable from " + argument.getReturnType());
                return false;
            }
            if (argument.isValid()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.getClass().getSimpleName());
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            sb.append(' ');
            if (this.getArgument(i) == null) {
                sb.append(this.getArgumentType(i).getSimpleName());
                continue;
            }
            sb.append(this.getArgument(i).toString());
        }
        sb.append(')');
        return sb.toString();
    }

    Class<?>[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public boolean isTerminal() {
        return this.getNumberOfArguments() == 0;
    }

    public int getNumberOfFunctions(Class<?> type) {
        return this.getNumberOfNodes(type, true, false);
    }

    public Node getFunctionAt(Class<?> type, int index) {
        return this.getNodeAt(type, true, false, index);
    }

    public int getNumberOfFunctions() {
        return this.getNumberOfFunctions(Object.class);
    }

    public Node getFunctionAt(int index) {
        return this.getFunctionAt(Object.class, index);
    }

    public int getNumberOfTerminals(Class<?> type) {
        return this.getNumberOfNodes(type, false, true);
    }

    public Node getTerminalAt(Class<?> type, int index) {
        return this.getNodeAt(type, false, true, index);
    }

    public int getNumberOfTerminals() {
        return this.getNumberOfTerminals(Object.class);
    }

    public Node getTerminalAt(int index) {
        return this.getTerminalAt(Object.class, index);
    }

    public int getNumberOfNodes(Class<?> type) {
        return this.getNumberOfNodes(type, true, true);
    }

    public Node getNodeAt(Class<?> type, int index) {
        return this.getNodeAt(type, true, true, index);
    }

    public int getNumberOfNodes() {
        return this.getNumberOfNodes(Object.class);
    }

    public Node getNodeAt(int index) {
        return this.getNodeAt(Object.class, index);
    }

    protected int getNumberOfNodes(Class<?> type, boolean includeFunctions, boolean includeTerminals) {
        int result = 0;
        if (this.isTerminal() && includeTerminals && type.isAssignableFrom(this.getReturnType()) || !this.isTerminal() && includeFunctions && type.isAssignableFrom(this.getReturnType())) {
            ++result;
        }
        for (Node argument : this.arguments) {
            result += argument.getNumberOfNodes(type, includeFunctions, includeTerminals);
        }
        return result;
    }

    protected Node getNodeAt(Class<?> type, boolean includeFunctions, boolean includeTerminals, int index) {
        if (this.isTerminal() && includeTerminals && type.isAssignableFrom(this.getReturnType()) || !this.isTerminal() && includeFunctions && type.isAssignableFrom(this.getReturnType())) {
            if (index == 0) {
                return this;
            }
            --index;
        }
        for (Node argument : this.arguments) {
            int size = argument.getNumberOfNodes(type, includeFunctions, includeTerminals);
            if (size > index) {
                return argument.getNodeAt(type, includeFunctions, includeTerminals, index);
            }
            index -= size;
        }
        throw new IndexOutOfBoundsException("index does not reference node in tree");
    }
}

