/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import org.apache.commons.math3.util.FastMath;
import org.moeaframework.core.Settings;

public class NumberArithmetic {
    private NumberArithmetic() {
    }

    public static boolean equals(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return a.doubleValue() == b.doubleValue();
        }
        return a.longValue() == b.longValue();
    }

    public static boolean lessThan(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return a.doubleValue() < b.doubleValue();
        }
        return a.longValue() < b.longValue();
    }

    public static boolean lessThanOrEqual(Number a, Number b) {
        return NumberArithmetic.lessThan(a, b) || NumberArithmetic.equals(a, b);
    }

    public static boolean greaterThan(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return a.doubleValue() > b.doubleValue();
        }
        return a.longValue() > b.longValue();
    }

    public static boolean greaterThanOrEqual(Number a, Number b) {
        return NumberArithmetic.greaterThan(a, b) || NumberArithmetic.equals(a, b);
    }

    public static Number add(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return a.doubleValue() + b.doubleValue();
        }
        return a.longValue() + b.longValue();
    }

    public static Number sqrt(Number a) {
        if (a.doubleValue() < 0.0 && Settings.isProtectedFunctions()) {
            return Math.sqrt(Math.abs(a.doubleValue()));
        }
        return Math.sqrt(a.doubleValue());
    }

    public static Number pow(Number a, Number b) {
        return Math.pow(a.doubleValue(), b.doubleValue());
    }

    public static Number sub(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return a.doubleValue() - b.doubleValue();
        }
        return a.longValue() - b.longValue();
    }

    public static Number mul(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return a.doubleValue() * b.doubleValue();
        }
        return a.longValue() * b.longValue();
    }

    public static Number div(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            if (Math.abs(b.doubleValue()) < 1.0E-10 && Settings.isProtectedFunctions()) {
                return 1.0;
            }
            return a.doubleValue() / b.doubleValue();
        }
        if (b.longValue() == 0L && Settings.isProtectedFunctions()) {
            return 1L;
        }
        return a.longValue() / b.longValue();
    }

    public static Number mod(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            if (Math.abs(b.doubleValue()) < 1.0E-10 && Settings.isProtectedFunctions()) {
                return 0.0;
            }
            return a.doubleValue() % b.doubleValue();
        }
        if (b.longValue() == 0L && Settings.isProtectedFunctions()) {
            return 0L;
        }
        return a.longValue() % b.longValue();
    }

    public static Number floor(Number a) {
        if (NumberArithmetic.isFloatingPoint(a)) {
            return Math.floor(a.doubleValue());
        }
        return a.longValue();
    }

    public static Number ceil(Number a) {
        if (NumberArithmetic.isFloatingPoint(a)) {
            return Math.ceil(a.doubleValue());
        }
        return a.longValue();
    }

    public static Number round(Number a) {
        if (NumberArithmetic.isFloatingPoint(a)) {
            return Math.round(a.doubleValue());
        }
        return a.longValue();
    }

    public static Number abs(Number a) {
        if (NumberArithmetic.isFloatingPoint(a)) {
            return Math.abs(a.doubleValue());
        }
        return Math.abs(a.longValue());
    }

    public static Number log(Number a) {
        if (a.doubleValue() < 1.0E-10 && Settings.isProtectedFunctions()) {
            double value = Math.abs(a.doubleValue());
            if (value < 1.0E-10) {
                return 0.0;
            }
            return Math.log(value);
        }
        return Math.log(a.doubleValue());
    }

    public static Number log10(Number a) {
        if (a.doubleValue() < 1.0E-10 && Settings.isProtectedFunctions()) {
            double value = Math.abs(a.doubleValue());
            if (value < 1.0E-10) {
                return 0.0;
            }
            return Math.log10(value);
        }
        return Math.log10(a.doubleValue());
    }

    public static Number exp(Number a) {
        return Math.exp(a.doubleValue());
    }

    public static Number sin(Number a) {
        return Math.sin(a.doubleValue());
    }

    public static Number cos(Number a) {
        return Math.cos(a.doubleValue());
    }

    public static Number tan(Number a) {
        return Math.tan(a.doubleValue());
    }

    public static Number asin(Number a) {
        return Math.asin(a.doubleValue());
    }

    public static Number acos(Number a) {
        return Math.acos(a.doubleValue());
    }

    public static Number atan(Number a) {
        return Math.atan(a.doubleValue());
    }

    public static Number sinh(Number a) {
        return Math.sinh(a.doubleValue());
    }

    public static Number cosh(Number a) {
        return Math.cosh(a.doubleValue());
    }

    public static Number tanh(Number a) {
        return Math.tanh(a.doubleValue());
    }

    public static Number asinh(Number a) {
        return FastMath.asinh((double)a.doubleValue());
    }

    public static Number acosh(Number a) {
        return FastMath.acosh((double)a.doubleValue());
    }

    public static Number atanh(Number a) {
        return FastMath.atanh((double)a.doubleValue());
    }

    public static Number max(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return Math.max(a.doubleValue(), b.doubleValue());
        }
        return Math.max(a.longValue(), b.longValue());
    }

    public static Number min(Number a, Number b) {
        if (NumberArithmetic.isFloatingPoint(a) || NumberArithmetic.isFloatingPoint(b)) {
            return Math.min(a.doubleValue(), b.doubleValue());
        }
        return Math.min(a.longValue(), b.longValue());
    }

    public static Number sign(Number a) {
        if (NumberArithmetic.isFloatingPoint(a)) {
            return Math.signum(a.doubleValue());
        }
        return Long.signum(a.longValue());
    }

    public static boolean isFloatingPoint(Number a) {
        return a instanceof Float || a instanceof Double;
    }
}

