/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import java.util.ArrayList;
import java.util.List;
import org.moeaframework.core.PRNG;
import org.moeaframework.util.tree.Abs;
import org.moeaframework.util.tree.Acos;
import org.moeaframework.util.tree.Acosh;
import org.moeaframework.util.tree.Add;
import org.moeaframework.util.tree.And;
import org.moeaframework.util.tree.Asin;
import org.moeaframework.util.tree.Asinh;
import org.moeaframework.util.tree.Atan;
import org.moeaframework.util.tree.Atanh;
import org.moeaframework.util.tree.Ceil;
import org.moeaframework.util.tree.Constant;
import org.moeaframework.util.tree.Cos;
import org.moeaframework.util.tree.Cosh;
import org.moeaframework.util.tree.Divide;
import org.moeaframework.util.tree.Equals;
import org.moeaframework.util.tree.Exp;
import org.moeaframework.util.tree.Floor;
import org.moeaframework.util.tree.GreaterThan;
import org.moeaframework.util.tree.GreaterThanOrEqual;
import org.moeaframework.util.tree.IfElse;
import org.moeaframework.util.tree.LessThan;
import org.moeaframework.util.tree.LessThanOrEqual;
import org.moeaframework.util.tree.Log;
import org.moeaframework.util.tree.Log10;
import org.moeaframework.util.tree.Max;
import org.moeaframework.util.tree.Min;
import org.moeaframework.util.tree.Modulus;
import org.moeaframework.util.tree.Multiply;
import org.moeaframework.util.tree.NOP;
import org.moeaframework.util.tree.Node;
import org.moeaframework.util.tree.Not;
import org.moeaframework.util.tree.Or;
import org.moeaframework.util.tree.Power;
import org.moeaframework.util.tree.Round;
import org.moeaframework.util.tree.Sequence;
import org.moeaframework.util.tree.Sign;
import org.moeaframework.util.tree.Sin;
import org.moeaframework.util.tree.Sinh;
import org.moeaframework.util.tree.Square;
import org.moeaframework.util.tree.SquareRoot;
import org.moeaframework.util.tree.Subtract;
import org.moeaframework.util.tree.Tan;
import org.moeaframework.util.tree.Tanh;

public class Rules {
    private Class<?> returnType = Void.class;
    private Node scaffolding;
    private int maxInitializationDepth = 5;
    private int maxVariationDepth = 10;
    private double functionCrossoverProbability = 0.5;
    private List<Node> availableNodes = new ArrayList<Node>();

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Node getScaffolding() {
        return this.scaffolding;
    }

    public void setScaffolding(Node scaffolding) {
        this.scaffolding = scaffolding;
        scaffolding.setFixedTree(true);
        this.setReturnType(scaffolding.getReturnType());
    }

    public int getMaxInitializationDepth() {
        return this.maxInitializationDepth;
    }

    public void setMaxInitializationDepth(int maxInitializationDepth) {
        this.maxInitializationDepth = maxInitializationDepth;
    }

    public int getMaxVariationDepth() {
        return this.maxVariationDepth;
    }

    public void setMaxVariationDepth(int maxVariationDepth) {
        this.maxVariationDepth = maxVariationDepth;
    }

    public double getFunctionCrossoverProbability() {
        return this.functionCrossoverProbability;
    }

    public void setFunctionCrossoverProbability(double functionCrossoverProbability) {
        this.functionCrossoverProbability = functionCrossoverProbability;
    }

    public void add(Node node) {
        this.availableNodes.add(node);
    }

    public void populateWithLogic() {
        this.add(new And());
        this.add(new Or());
        this.add(new Not());
        this.add(new Equals());
        this.add(new GreaterThan());
        this.add(new LessThan());
        this.add(new GreaterThanOrEqual());
        this.add(new LessThanOrEqual());
        this.add(new Constant(true));
        this.add(new Constant(false));
    }

    public void populateWithArithmetic() {
        this.add(new Add());
        this.add(new Subtract());
        this.add(new Multiply());
        this.add(new Divide());
        this.add(new Modulus());
        this.add(new Floor());
        this.add(new Ceil());
        this.add(new Round());
        this.add(new Max());
        this.add(new Min());
        this.add(new Power());
        this.add(new Square());
        this.add(new SquareRoot());
        this.add(new Abs());
        this.add(new Log());
        this.add(new Log10());
        this.add(new Exp());
        this.add(new Sign());
    }

    public void populateWithTrig() {
        this.add(new Sin());
        this.add(new Cos());
        this.add(new Tan());
        this.add(new Asin());
        this.add(new Acos());
        this.add(new Atan());
        this.add(new Sinh());
        this.add(new Cosh());
        this.add(new Tanh());
        this.add(new Asinh());
        this.add(new Acosh());
        this.add(new Atanh());
    }

    public void populateWithControl() {
        this.add(new IfElse());
        this.add(new IfElse(Number.class));
        this.add(new Sequence());
        this.add(new NOP());
    }

    public void populateWithConstants() {
        this.add(new Constant(0L));
        this.add(new Constant(1L));
        this.add(new Constant(2L));
        this.add(new Constant(10L));
        this.add(new Constant(-1L));
        this.add(new Constant(Math.E));
        this.add(new Constant(Math.PI));
    }

    public void populateWithDefaults() {
        this.populateWithLogic();
        this.populateWithArithmetic();
        this.populateWithTrig();
        this.populateWithControl();
        this.populateWithConstants();
    }

    public List<Node> getAvailableNodes() {
        return this.availableNodes;
    }

    public List<Node> listAvailableCrossoverNodes(Node node, Class<?> type) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (type.isAssignableFrom(node.getReturnType())) {
            result.add(node);
        }
        for (int i = 0; i < node.getNumberOfArguments(); ++i) {
            result.addAll(this.listAvailableCrossoverNodes(node.getArgument(i), type));
        }
        return result;
    }

    public List<Node> listAvailableMutations(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node mutation : this.availableNodes) {
            if (!this.isMutationCompatible(node, mutation)) continue;
            result.add(mutation);
        }
        return result;
    }

    protected boolean isMutationCompatible(Node original, Node mutation) {
        if (!original.getReturnType().isAssignableFrom(mutation.getReturnType())) {
            return false;
        }
        if (original.getNumberOfArguments() != mutation.getNumberOfArguments()) {
            return false;
        }
        for (int i = 0; i < original.getNumberOfArguments(); ++i) {
            if (original.getArgumentType(i).isAssignableFrom(mutation.getArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    public List<Node> listAvailableNodes(Class<?> type) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : this.availableNodes) {
            if (!type.isAssignableFrom(node.getReturnType())) continue;
            result.add(node);
        }
        return result;
    }

    public List<Node> listAvailableTerminals(Class<?> type) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : this.availableNodes) {
            if (node.getNumberOfArguments() != 0 || !type.isAssignableFrom(node.getReturnType())) continue;
            result.add(node);
        }
        return result;
    }

    public List<Node> listAvailableFunctions(Class<?> type) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : this.availableNodes) {
            if (node.getNumberOfArguments() <= 0 || !type.isAssignableFrom(node.getReturnType())) continue;
            result.add(node);
        }
        if (result.isEmpty()) {
            result.addAll(this.listAvailableTerminals(type));
        }
        return result;
    }

    public Node buildTreeFull(Class<?> type, int depth) {
        if (depth == 0) {
            return PRNG.nextItem(this.listAvailableTerminals(type)).copyNode();
        }
        Node node = PRNG.nextItem(this.listAvailableFunctions(type)).copyNode();
        for (int i = 0; i < node.getNumberOfArguments(); ++i) {
            node.setArgument(i, this.buildTreeFull(node.getArgumentType(i), depth - 1));
        }
        return node;
    }

    public Node buildTreeGrow(Class<?> type, int depth) {
        if (depth == 0) {
            return PRNG.nextItem(this.listAvailableTerminals(type)).copyNode();
        }
        Node node = PRNG.nextItem(this.listAvailableNodes(type)).copyNode();
        for (int i = 0; i < node.getNumberOfArguments(); ++i) {
            node.setArgument(i, this.buildTreeGrow(node.getArgumentType(i), depth - 1));
        }
        return node;
    }

    public Node buildTreeFull(Node node, int depth) {
        if (depth == 0) {
            return node.copyNode();
        }
        Node copy = node.copyNode();
        for (int i = 0; i < node.getNumberOfArguments(); ++i) {
            if (node.getArgument(i) == null) {
                copy.setArgument(i, this.buildTreeFull(node.getArgumentType(i), depth - 1));
                continue;
            }
            copy.setArgument(i, this.buildTreeFull(node.getArgument(i), depth - 1));
        }
        return copy;
    }

    public Node buildTreeGrow(Node node, int depth) {
        if (depth == 0) {
            return node.copyNode();
        }
        Node copy = node.copyNode();
        for (int i = 0; i < node.getNumberOfArguments(); ++i) {
            if (node.getArgument(i) == null) {
                copy.setArgument(i, this.buildTreeGrow(node.getArgumentType(i), depth - 1));
                continue;
            }
            copy.setArgument(i, this.buildTreeGrow(node.getArgument(i), depth - 1));
        }
        return copy;
    }
}

