/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.tree;

import org.moeaframework.util.tree.Environment;
import org.moeaframework.util.tree.Node;
import org.moeaframework.util.tree.NumberArithmetic;

public class Truncate
extends Node {
    private final double min;
    private final double max;

    public Truncate(double min, double max) {
        super(Number.class, Number.class);
        this.min = min;
        this.max = max;
    }

    @Override
    public Truncate copyNode() {
        return new Truncate(this.min, this.max);
    }

    @Override
    public Number evaluate(Environment environment) {
        Number value = (Number)this.getArgument(0).evaluate(environment);
        if (NumberArithmetic.lessThan(value, this.min)) {
            return this.min;
        }
        if (NumberArithmetic.greaterThan(value, this.max)) {
            return this.max;
        }
        return value;
    }
}

