/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.weights;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.moeaframework.util.weights.WeightGenerator;

public class NormalBoundaryIntersectionGenerator
implements WeightGenerator {
    private final int numberOfObjectives;
    private final int divisionsOuter;
    private final int divisionsInner;

    public NormalBoundaryIntersectionGenerator(int numberOfObjectives, int divisions) {
        this(numberOfObjectives, divisions, 0);
    }

    public NormalBoundaryIntersectionGenerator(int numberOfObjectives, int divisionsOuter, int divisionsInner) {
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
    }

    @Override
    public int size() {
        long size = 0L;
        size += CombinatoricsUtils.binomialCoefficient((int)(this.numberOfObjectives + this.divisionsOuter - 1), (int)this.divisionsOuter);
        if (this.divisionsInner > 0) {
            size += CombinatoricsUtils.binomialCoefficient((int)(this.numberOfObjectives + this.divisionsInner - 1), (int)this.divisionsInner);
        }
        return (int)size;
    }

    @Override
    public List<double[]> generate() {
        List<double[]> weights = null;
        if (this.divisionsInner > 0) {
            if (this.divisionsOuter >= this.numberOfObjectives) {
                System.err.println("The specified number of outer divisions produces intermediate reference points, recommend setting divisionsOuter < numberOfObjectives.");
            }
            weights = this.generateWeights(this.divisionsOuter);
            List<double[]> inner = this.generateWeights(this.divisionsInner);
            for (int i = 0; i < inner.size(); ++i) {
                double[] weight = inner.get(i);
                for (int j = 0; j < weight.length; ++j) {
                    weight[j] = (1.0 / (double)this.numberOfObjectives + weight[j]) / 2.0;
                }
            }
            weights.addAll(inner);
        } else {
            if (this.divisionsOuter < this.numberOfObjectives) {
                System.err.println("No intermediate reference points will be generated for the specified number of divisions, recommend increasing divisions");
            }
            weights = this.generateWeights(this.divisionsOuter);
        }
        return weights;
    }

    private List<double[]> generateWeights(int divisions) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        double[] weight = new double[this.numberOfObjectives];
        this.generateRecursive(result, weight, this.numberOfObjectives, divisions, divisions, 0);
        return result;
    }

    private void generateRecursive(List<double[]> weights, double[] weight, int numberOfObjectives, int left, int total, int index) {
        if (index == numberOfObjectives - 1) {
            weight[index] = (double)left / (double)total;
            weights.add((double[])weight.clone());
        } else {
            for (int i = 0; i <= left; ++i) {
                weight[index] = (double)i / (double)total;
                this.generateRecursive(weights, weight, numberOfObjectives, left - i, total, index + 1);
            }
        }
    }
}

