/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.weights;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.MathArrays;
import org.moeaframework.core.PRNG;
import org.moeaframework.util.weights.WeightGenerator;

public class RandomGenerator
implements WeightGenerator {
    private final int numberOfObjectives;
    private final int numberOfPoints;

    public RandomGenerator(int numberOfObjectives, int numberOfPoints) {
        this.numberOfObjectives = numberOfObjectives;
        this.numberOfPoints = numberOfPoints;
    }

    private List<double[]> initializeWeights2D() {
        ArrayList<double[]> weights = new ArrayList<double[]>();
        weights.add(new double[]{0.0, 1.0});
        weights.add(new double[]{1.0, 0.0});
        for (int i = 1; i < this.numberOfPoints - 1; ++i) {
            double a = (double)i / (double)(this.numberOfPoints - 1);
            weights.add(new double[]{a, 1.0 - a});
        }
        return weights;
    }

    private List<double[]> initializeWeightsND() {
        int N = 50;
        ArrayList<double[]> candidates = new ArrayList<double[]>(this.numberOfPoints * N);
        for (int i = 0; i < this.numberOfPoints * N; ++i) {
            double[] weight = new double[this.numberOfObjectives];
            for (int j = 0; j < this.numberOfObjectives; ++j) {
                weight[j] = PRNG.nextDouble();
            }
            double sum = StatUtils.sum((double[])weight);
            int j = 0;
            while (j < this.numberOfObjectives) {
                int n = j++;
                weight[n] = weight[n] / sum;
            }
            candidates.add(weight);
        }
        ArrayList<double[]> weights = new ArrayList<double[]>(this.numberOfPoints * N);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            double[] weight = new double[this.numberOfObjectives];
            weight[i] = 1.0;
            weights.add(weight);
        }
        while (weights.size() < this.numberOfPoints) {
            double[] weight = null;
            double distance = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < candidates.size(); ++i) {
                double d = Double.POSITIVE_INFINITY;
                for (int j = 0; j < weights.size(); ++j) {
                    d = Math.min(d, MathArrays.distance((double[])((double[])candidates.get(i)), (double[])((double[])weights.get(j))));
                }
                if (!(d > distance)) continue;
                weight = (double[])candidates.get(i);
                distance = d;
            }
            weights.add(weight);
            candidates.remove(weight);
        }
        return weights;
    }

    @Override
    public int size() {
        return this.numberOfPoints;
    }

    @Override
    public List<double[]> generate() {
        if (this.numberOfObjectives == 2) {
            return this.initializeWeights2D();
        }
        return this.initializeWeightsND();
    }
}

