/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.util.weights;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.primes.Primes;
import org.moeaframework.util.weights.WeightGenerator;

public class UniformDesignGenerator
implements WeightGenerator {
    private final int numberOfObjectives;
    private final int numberOfPoints;

    public UniformDesignGenerator(int numberOfObjectives, int numberOfPoints) {
        this.numberOfObjectives = numberOfObjectives;
        this.numberOfPoints = numberOfPoints;
    }

    @Override
    public int size() {
        return this.numberOfPoints;
    }

    protected int[] generateFirstKPrimes(int k) {
        int[] primes = new int[k];
        primes[0] = 2;
        for (int i = 1; i < k; ++i) {
            primes[i] = Primes.nextPrime((int)primes[i - 1]);
        }
        return primes;
    }

    @Override
    public List<double[]> generate() {
        ArrayList<double[]> designs = new ArrayList<double[]>();
        int[] primes = this.generateFirstKPrimes(this.numberOfObjectives - 2);
        for (int i = 0; i < this.numberOfPoints; ++i) {
            double[] design = new double[this.numberOfObjectives - 1];
            design[0] = (2.0 * (double)(i + 1) - 1.0) / (2.0 * (double)this.numberOfPoints);
            for (int j = 1; j < this.numberOfObjectives - 1; ++j) {
                double f = 1.0 / (double)primes[j - 1];
                int d = i + 1;
                design[j] = 0.0;
                while (d > 0) {
                    int n = j;
                    design[n] = design[n] + f * (double)(d % primes[j - 1]);
                    d /= primes[j - 1];
                    f /= (double)primes[j - 1];
                }
            }
            designs.add(design);
        }
        ArrayList<double[]> weights = new ArrayList<double[]>();
        for (double[] design : designs) {
            double[] weight = new double[this.numberOfObjectives];
            for (int i = 1; i <= this.numberOfObjectives; ++i) {
                weight[i - 1] = i == this.numberOfObjectives ? 1.0 : 1.0 - Math.pow(design[i - 1], 1.0 / (double)(this.numberOfObjectives - i));
                for (int j = 1; j <= i - 1; ++j) {
                    int n = i - 1;
                    weight[n] = weight[n] * Math.pow(design[j - 1], 1.0 / (double)(this.numberOfObjectives - j));
                }
            }
            weights.add(weight);
        }
        return weights;
    }
}

