/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.mongodb.morphia.utils.Assert;

public class VerboseJSR303ConstraintViolationException
extends ConstraintViolationException {
    public VerboseJSR303ConstraintViolationException(Set<ConstraintViolation<?>> vio) {
        super(VerboseJSR303ConstraintViolationException.createVerboseMessage(vio), vio);
        Assert.parameterNotNull((String)"vio", vio);
    }

    private static String createVerboseMessage(Set<ConstraintViolation<?>> vio) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("The following constraints have been violated:\n");
        for (ConstraintViolation<?> c : vio) {
            sb.append(c.getRootBeanClass().getSimpleName());
            sb.append(".");
            sb.append(c.getPropertyPath());
            sb.append(": ");
            sb.append(c.getMessage());
            sb.append(" ('");
            sb.append(c.getInvalidValue());
            sb.append("')\n");
        }
        return sb.toString();
    }
}

