/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.eclipse.jetty.npn.NextProtoNego;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.NextProtoNegoExtension;
import sun.security.ssl.NextProtocolMessage;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ClientHandshaker
extends Handshaker {
    private PublicKey serverKey;
    private PublicKey ephemeralServerKey;
    private BigInteger serverDH;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;
    private static final boolean enableSNIExtension = Debug.getBooleanProperty((String)"jsse.enableSNIExtension", (boolean)true);
    private static final boolean allowUnsafeServerCertChange = Debug.getBooleanProperty((String)"jdk.tls.allowUnsafeServerCertChange", (boolean)false);
    private X509Certificate[] reservedServerCerts = null;
    private List<String> protocols;

    ClientHandshaker(SSLSocketImpl socket, SSLContextImpl context, ProtocolList enabledProtocols, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(socket, context, enabledProtocols, true, true, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    ClientHandshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(engine, context, enabledProtocols, true, true, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    @Override
    void processMessage(byte type, int messageLen) throws IOException {
        if (this.state >= type && type != 0) {
            throw new SSLProtocolException("Handshake message sequence violation, " + type);
        }
        block4 : switch (type) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input, messageLen));
                break;
            }
            case 11: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                switch (this.keyExchange) {
                    case K_RSA_EXPORT: {
                        if (this.serverKey == null) {
                            throw new SSLProtocolException("Server did not send certificate message");
                        }
                        if (!(this.serverKey instanceof RSAPublicKey)) {
                            throw new SSLProtocolException("Protocol violation: the certificate type must be appropriate for the selected cipher suite's key exchange algorithm");
                        }
                        if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                            throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange) + " when the public key in the server certificate" + " is less than or equal to 512 bits in length");
                        }
                        try {
                            this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block4;
                    }
                    case K_DH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.protocolVersion));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block4;
                    }
                    case K_DHE_DSS: 
                    case K_DHE_RSA: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, messageLen, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block4;
                    }
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.ECDH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException("Server key", e);
                        }
                        break block4;
                    }
                    case K_RSA: 
                    case K_DH_RSA: 
                    case K_DH_DSS: 
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: {
                        throw new SSLProtocolException("Protocol violation: server sent a server key exchangemessage for key exchange " + (Object)((Object)this.keyExchange));
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.keyExchange));
            }
            case 13: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input, this.protocolVersion);
                if (debug != null && Debug.isOn((String)"handshake")) {
                    this.certRequest.print(System.out);
                }
                if (this.protocolVersion.v < ProtocolVersion.TLS12.v) break;
                Collection peerSignAlgs = this.certRequest.getSignAlgorithms();
                if (peerSignAlgs == null || peerSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No peer supported signature algorithms");
                }
                Collection supportedPeerSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms((Collection)peerSignAlgs);
                if (supportedPeerSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature and hash algorithm in common");
                }
                this.setPeerSupportedSignAlgs(supportedPeerSignAlgs);
                this.session.setPeerSupportedSignatureAlgorithms(supportedPeerSignAlgs);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + type);
            }
        }
        if (this.state < type) {
            this.state = type;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest mesg) throws IOException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (this.state < 1) {
            if (!this.secureRenegotiation && !allowUnsafeRenegotiation) {
                if (this.activeProtocolVersion.v >= ProtocolVersion.TLS10.v) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                } else {
                    this.fatalSE((byte)40, "Renegotiation is not allowed");
                }
            } else {
                if (!this.secureRenegotiation && debug != null && Debug.isOn((String)"handshake")) {
                    System.out.println("Warning: continue with insecure renegotiation");
                }
                this.kickstart();
            }
        }
    }

    private void serverHello(HandshakeMessage.ServerHello mesg) throws IOException {
        ProtocolVersion mesgVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (!this.isNegotiable(mesgVersion = mesg.protocolVersion)) {
            throw new SSLHandshakeException("Server chose " + (Object)((Object)mesgVersion) + ", but that protocol version is not enabled or not supported " + "by the client.");
        }
        this.handshakeHash.protocolDetermined(mesgVersion);
        this.setVersion(mesgVersion);
        RenegotiationInfoExtension serverHelloRI = (RenegotiationInfoExtension)mesg.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (serverHelloRI != null) {
            if (this.isInitialHandshake) {
                if (!serverHelloRI.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "Unexpected renegotiation indication extension");
                }
                byte[] verifyData = new byte[this.clientVerifyData.length + this.serverVerifyData.length];
                System.arraycopy(this.clientVerifyData, 0, verifyData, 0, this.clientVerifyData.length);
                System.arraycopy(this.serverVerifyData, 0, verifyData, this.clientVerifyData.length, this.serverVerifyData.length);
                if (!Arrays.equals(verifyData, serverHelloRI.getRenegotiatedConnection())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ServerHello renegotiation_info message");
                }
            }
        } else if (this.isInitialHandshake) {
            if (!allowLegacyHelloMessages) {
                this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
            }
            this.secureRenegotiation = false;
            if (debug != null && Debug.isOn((String)"handshake")) {
                System.out.println("Warning: No renegotiation indication extension in ServerHello");
            }
        } else if (this.secureRenegotiation) {
            this.fatalSE((byte)40, "No renegotiation indication extension");
        }
        this.svr_random = mesg.svr_random;
        if (!this.isNegotiable(mesg.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected improper ciphersuite " + (Object)((Object)mesg.cipherSuite));
        }
        this.setCipherSuite(mesg.cipherSuite);
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.getPRFHashAlg());
        }
        if (mesg.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + mesg.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(mesg.sessionId)) {
                CipherSuite sessionSuite = this.session.getSuite();
                if (this.cipherSuite != sessionSuite) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion sessionVersion = this.session.getProtocolVersion();
                if (this.protocolVersion != sessionVersion) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (sessionSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || sessionSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    Principal localPrincipal;
                    block42: {
                        localPrincipal = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Helper.getClientSubject((AccessControlContext)ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            subject = null;
                            if (debug == null || !Debug.isOn((String)"session")) break block42;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<Principal> principals = subject.getPrincipals(Principal.class);
                        if (!principals.contains(localPrincipal)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn((String)"session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn((String)"session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
            } else {
                this.session = null;
                if (!this.enableNewSession) {
                    throw new SSLException("New session creation is disabled");
                }
            }
        }
        if (this.resumingSession && this.session != null) {
            if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                this.handshakeHash.setCertificateVerifyAlg(null);
            }
            this.setHandshakeSessionSE(this.session);
            if (this.isInitialHandshake) {
                this.session.setAsSessionResumption(true);
            }
            return;
        }
        for (HelloExtension ext : mesg.extensions.list()) {
            ExtensionType type = ext.type;
            if (type == ExtensionType.EXT_ELLIPTIC_CURVES || type == ExtensionType.EXT_EC_POINT_FORMATS || type == ExtensionType.EXT_SERVER_NAME || type == ExtensionType.EXT_NEXT_PROTOCOL_NEGOTIATION || type == ExtensionType.EXT_RENEGOTIATION_INFO) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + type);
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.getLocalSupportedSignAlgs(), mesg.sessionId, this.getHostSE(), this.getPortSE());
        this.setHandshakeSessionSE(this.session);
        if (debug != null && Debug.isOn((String)"handshake")) {
            System.out.println("** " + (Object)((Object)this.cipherSuite));
        }
        if (this.isInitialHandshake) {
            NextProtoNegoExtension extension = (NextProtoNegoExtension)mesg.extensions.get(ExtensionType.EXT_NEXT_PROTOCOL_NEGOTIATION);
            if (extension != null) {
                this.protocols = extension.getProtocols();
                if (NextProtoNego.debug) {
                    System.err.println(new StringBuilder("[C] NPN protocols ").append(this.protocols).append(" received from server for ").append(this.conn != null ? this.conn : this.engine));
                }
            } else if (NextProtoNego.debug) {
                System.err.println(new StringBuilder("[C] NPN protocols not sent by server for ").append(this.conn != null ? this.conn : this.engine));
            }
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange mesg) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (!mesg.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.ephemeralServerKey = mesg.getPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        this.dh = new DHCrypt(mesg.getModulus(), mesg.getBase(), this.sslContext.getSecureRandom());
        this.serverDH = mesg.getServerPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.ECDH_ServerKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        ECPublicKey key = mesg.getPublicKey();
        this.ecdh = new ECDHCrypt(key.getParams(), this.sslContext.getSecureRandom());
        this.ephemeralServerKey = key;
    }

    private void serverHelloDone(HandshakeMessage.ServerHelloDone mesg) throws IOException {
        SecretKey preMasterSecret;
        Object m2;
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        this.input.digestNow();
        Key signingKey = null;
        if (this.certRequest != null) {
            X509Certificate[] certs;
            X509ExtendedKeyManager km = this.sslContext.getX509KeyManager();
            ArrayList<String> keytypesTmp = new ArrayList<String>(4);
            for (int i = 0; i < this.certRequest.types.length; ++i) {
                String typeName;
                switch (this.certRequest.types[i]) {
                    case 1: {
                        typeName = "RSA";
                        break;
                    }
                    case 2: {
                        typeName = "DSA";
                        break;
                    }
                    case 64: {
                        typeName = JsseJce.isEcAvailable() ? "EC" : null;
                        break;
                    }
                    default: {
                        typeName = null;
                    }
                }
                if (typeName == null || keytypesTmp.contains(typeName)) continue;
                keytypesTmp.add(typeName);
            }
            String alias = null;
            int keytypesTmpSize = keytypesTmp.size();
            if (keytypesTmpSize != 0) {
                String[] keytypes = keytypesTmp.toArray(new String[keytypesTmpSize]);
                alias = this.conn != null ? km.chooseClientAlias(keytypes, this.certRequest.getAuthorities(), this.conn) : km.chooseEngineClientAlias(keytypes, this.certRequest.getAuthorities(), this.engine);
            }
            HandshakeMessage.CertificateMsg m1 = null;
            if (alias != null && (certs = km.getCertificateChain(alias)) != null && certs.length != 0) {
                ECParameterSpec params;
                int index;
                PublicKey publicKey = certs[0].getPublicKey();
                if (publicKey instanceof ECPublicKey && !SupportedEllipticCurvesExtension.isSupported(index = SupportedEllipticCurvesExtension.getCurveIndex(params = ((ECPublicKey)publicKey).getParams()))) {
                    publicKey = null;
                }
                if (publicKey != null) {
                    m1 = new HandshakeMessage.CertificateMsg(certs);
                    signingKey = km.getPrivateKey(alias);
                    this.session.setLocalPrivateKey((PrivateKey)signingKey);
                    this.session.setLocalCertificates(certs);
                }
            }
            if (m1 == null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                    m1 = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
                } else {
                    this.warningSE((byte)41);
                }
            }
            if (m1 != null) {
                if (debug != null && Debug.isOn((String)"handshake")) {
                    m1.print(System.out);
                }
                m1.write(this.output);
            }
        }
        switch (this.keyExchange) {
            case K_RSA_EXPORT: 
            case K_RSA: {
                PublicKey key;
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof RSAPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an RSA key");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_RSA) {
                    key = this.serverKey;
                } else if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                    key = this.serverKey;
                } else {
                    if (this.ephemeralServerKey == null) {
                        throw new SSLProtocolException("Server did not send a RSA_EXPORT Server Key Exchange message");
                    }
                    key = this.ephemeralServerKey;
                }
                m2 = new RSAClientKeyExchange(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), key);
                break;
            }
            case K_DH_RSA: 
            case K_DH_DSS: {
                m2 = new DHClientKeyExchange();
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                if (this.dh == null) {
                    throw new SSLProtocolException("Server did not send a DH Server Key Exchange message");
                }
                m2 = new DHClientKeyExchange(this.dh.getPublicKey());
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                if (this.ecdh == null) {
                    throw new SSLProtocolException("Server did not send a ECDH Server Key Exchange message");
                }
                m2 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an EC key");
                }
                ECParameterSpec params = ((ECPublicKey)this.serverKey).getParams();
                this.ecdh = new ECDHCrypt(params, this.sslContext.getSecureRandom());
                m2 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                String hostname = this.getHostSE();
                if (hostname == null) {
                    throw new IOException("Hostname is required to use Kerberos cipher suites");
                }
                KerberosClientKeyExchange kerberosMsg = new KerberosClientKeyExchange(hostname, this.isLoopbackSE(), this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                this.session.setPeerPrincipal(kerberosMsg.getPeerPrincipal());
                this.session.setLocalPrincipal(kerberosMsg.getLocalPrincipal());
                m2 = kerberosMsg;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)((Object)this.keyExchange));
            }
        }
        if (debug != null && Debug.isOn((String)"handshake")) {
            m2.print(System.out);
        }
        m2.write(this.output);
        this.output.doHashes();
        this.output.flush();
        switch (this.keyExchange) {
            case K_RSA_EXPORT: 
            case K_RSA: {
                preMasterSecret = ((RSAClientKeyExchange)m2).preMaster;
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                byte[] secretBytes = ((KerberosClientKeyExchange)m2).getUnencryptedPreMasterSecret();
                preMasterSecret = new SecretKeySpec(secretBytes, "TlsPremasterSecret");
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                preMasterSecret = this.dh.getAgreedSecret(this.serverDH, true);
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                preMasterSecret = this.ecdh.getAgreedSecret(this.ephemeralServerKey);
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                preMasterSecret = this.ecdh.getAgreedSecret(this.serverKey);
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)((Object)this.keyExchange));
            }
        }
        this.calculateKeys(preMasterSecret, null);
        if (signingKey != null) {
            HandshakeMessage.CertificateVerify m3;
            try {
                SignatureAndHashAlgorithm preferableSignatureAlgorithm = null;
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm((Collection)this.peerSupportedSignAlgs, (String)signingKey.getAlgorithm(), (PrivateKey)signingKey);
                    if (preferableSignatureAlgorithm == null) {
                        throw new SSLHandshakeException("No supported signature algorithm");
                    }
                    String hashAlg = SignatureAndHashAlgorithm.getHashAlgorithmName((SignatureAndHashAlgorithm)preferableSignatureAlgorithm);
                    if (hashAlg == null || hashAlg.length() == 0) {
                        throw new SSLHandshakeException("No supported hash algorithm");
                    }
                    this.handshakeHash.setCertificateVerifyAlg(hashAlg);
                }
                m3 = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, (PrivateKey)signingKey, this.session.getMasterSecret(), this.sslContext.getSecureRandom(), preferableSignatureAlgorithm);
            }
            catch (GeneralSecurityException e) {
                this.fatalSE((byte)40, "Error signing certificate verify", e);
                m3 = null;
            }
            if (debug != null && Debug.isOn((String)"handshake")) {
                m3.print(System.out);
            }
            m3.write(this.output);
            this.output.doHashes();
        } else if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setCertificateVerifyAlg(null);
        }
        this.sendChangeCipherAndFinish(false);
    }

    private void serverFinished(HandshakeMessage.Finished mesg) throws IOException {
        boolean verified;
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (!(verified = mesg.verify(this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.serverVerifyData = mesg.getVerifyData();
        }
        if (!this.isInitialHandshake) {
            this.session.setAsSessionResumption(false);
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn((String)"session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish(boolean finishedTag) throws IOException {
        HandshakeMessage.Finished mesg = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(mesg, finishedTag);
        if (this.secureRenegotiation) {
            this.clientVerifyData = mesg.getVerifyData();
        }
        this.state = 19;
    }

    @Override
    HandshakeMessage getKickstartMessage() throws SSLException {
        String hostname;
        SessionId sessionId = SSLSessionImpl.nullSession.getSessionId();
        CipherSuiteList cipherSuites = this.getActiveCipherSuites();
        this.maxProtocolVersion = this.protocolVersion;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn((String)"session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null) {
            if (!allowUnsafeServerCertChange && this.session.isSessionResumption()) {
                try {
                    this.reservedServerCerts = (X509Certificate[])this.session.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException puve) {
                    // empty catch block
                }
            }
            if (!this.session.isRejoinable()) {
                this.session = null;
            }
        }
        if (this.session != null) {
            CipherSuite sessionSuite = this.session.getSuite();
            ProtocolVersion sessionVersion = this.session.getProtocolVersion();
            if (!this.isNegotiable(sessionSuite)) {
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% can't resume, unavailable cipher");
                }
                this.session = null;
            }
            if (this.session != null && !this.isNegotiable(sessionVersion)) {
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn((String)"handshake") || Debug.isOn((String)"session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                sessionId = this.session.getSessionId();
                this.maxProtocolVersion = sessionVersion;
                this.setVersion(sessionVersion);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLHandshakeException("Can't reuse existing SSL client session");
                }
                ArrayList<CipherSuite> cipherList = new ArrayList<CipherSuite>(2);
                cipherList.add(sessionSuite);
                if (!this.secureRenegotiation && cipherSuites.contains(CipherSuite.C_SCSV)) {
                    cipherList.add(CipherSuite.C_SCSV);
                }
                cipherSuites = new CipherSuiteList(cipherList);
            }
        }
        if (this.session == null && !this.enableNewSession) {
            throw new SSLHandshakeException("No existing session to resume");
        }
        if (this.secureRenegotiation && cipherSuites.contains(CipherSuite.C_SCSV)) {
            ArrayList<CipherSuite> cipherList = new ArrayList<CipherSuite>(cipherSuites.size() - 1);
            for (CipherSuite suite : cipherSuites.collection()) {
                if (suite == CipherSuite.C_SCSV) continue;
                cipherList.add(suite);
            }
            cipherSuites = new CipherSuiteList(cipherList);
        }
        boolean negotiable = false;
        for (CipherSuite suite : cipherSuites.collection()) {
            if (!this.isNegotiable(suite)) continue;
            negotiable = true;
            break;
        }
        if (!negotiable) {
            throw new SSLHandshakeException("No negotiable cipher suite");
        }
        HandshakeMessage.ClientHello clientHelloMessage = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.maxProtocolVersion, sessionId, cipherSuites);
        if (this.maxProtocolVersion.v >= ProtocolVersion.TLS12.v) {
            Collection<SignatureAndHashAlgorithm> localSignAlgs = this.getLocalSupportedSignAlgs();
            if (localSignAlgs.isEmpty()) {
                throw new SSLHandshakeException("No supported signature algorithm");
            }
            clientHelloMessage.addSignatureAlgorithmsExtension(localSignAlgs);
        }
        if (enableSNIExtension && (hostname = this.getRawHostnameSE()) != null && hostname.indexOf(46) > 0 && !IPAddressUtil.isIPv4LiteralAddress(hostname) && !IPAddressUtil.isIPv6LiteralAddress(hostname)) {
            clientHelloMessage.addServerNameIndicationExtension(hostname);
        }
        this.clnt_random = clientHelloMessage.clnt_random;
        if (this.secureRenegotiation || !cipherSuites.contains(CipherSuite.C_SCSV)) {
            clientHelloMessage.addRenegotiationInfoExtension(this.clientVerifyData);
        }
        if (this.isInitialHandshake) {
            NextProtoNego.ClientProvider provider;
            NextProtoNego.ClientProvider clientProvider = provider = this.conn != null ? (NextProtoNego.ClientProvider)NextProtoNego.get(this.conn) : (NextProtoNego.ClientProvider)NextProtoNego.get(this.engine);
            if (provider != null) {
                if (provider.supports()) {
                    if (NextProtoNego.debug) {
                        System.err.println(new StringBuilder("[C] NPN supported for ").append(this.conn != null ? this.conn : this.engine));
                    }
                    clientHelloMessage.extensions.add(new NextProtoNegoExtension());
                } else if (NextProtoNego.debug) {
                    System.err.println(new StringBuilder("[C] NPN not supported for ").append(this.conn != null ? this.conn : this.engine));
                }
            } else if (NextProtoNego.debug) {
                System.err.println(new StringBuilder("[C] NPN client provider not present for ").append(this.conn != null ? this.conn : this.engine));
            }
        }
        return clientHelloMessage;
    }

    @Override
    void handshakeAlert(byte description) throws SSLProtocolException {
        String message = Alerts.alertDescription((byte)description);
        if (debug != null && Debug.isOn((String)"handshake")) {
            System.out.println("SSL - handshake alert: " + message);
        }
        throw new SSLProtocolException("handshake alert:  " + message);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg mesg) throws IOException {
        X509Certificate[] peerCerts;
        block8: {
            String identityAlg;
            if (debug != null && Debug.isOn((String)"handshake")) {
                mesg.print(System.out);
            }
            if ((peerCerts = mesg.getCertificateChain()).length == 0) {
                this.fatalSE((byte)42, "empty certificate chain");
            }
            if (!(this.reservedServerCerts == null || (identityAlg = this.getEndpointIdentificationAlgorithmSE()) != null && identityAlg.length() != 0 || ClientHandshaker.isIdentityEquivalent(peerCerts[0], this.reservedServerCerts[0]))) {
                this.fatalSE((byte)42, "server certificate change is restrictedduring renegotiation");
            }
            X509TrustManager tm = this.sslContext.getX509TrustManager();
            try {
                String keyExchangeString = this.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT && !this.serverKeyExchangeReceived ? CipherSuite.KeyExchange.K_RSA.name : this.keyExchange.name;
                if (tm instanceof X509ExtendedTrustManager) {
                    if (this.conn != null) {
                        ((X509ExtendedTrustManager)tm).checkServerTrusted((X509Certificate[])peerCerts.clone(), keyExchangeString, this.conn);
                    } else {
                        ((X509ExtendedTrustManager)tm).checkServerTrusted((X509Certificate[])peerCerts.clone(), keyExchangeString, this.engine);
                    }
                    break block8;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException e) {
                this.fatalSE((byte)46, e);
            }
        }
        this.session.setPeerCertificates(peerCerts);
    }

    private static boolean isIdentityEquivalent(X509Certificate thisCert, X509Certificate prevCert) {
        if (thisCert.equals(prevCert)) {
            return true;
        }
        Object thisIPAddress = ClientHandshaker.getSubjectAltName(thisCert, 7);
        Object prevIPAddress = ClientHandshaker.getSubjectAltName(prevCert, 7);
        if (thisIPAddress != null && prevIPAddress != null) {
            return Objects.equals(thisIPAddress, prevIPAddress);
        }
        Object thisDNSName = ClientHandshaker.getSubjectAltName(thisCert, 2);
        Object prevDNSName = ClientHandshaker.getSubjectAltName(prevCert, 2);
        if (thisDNSName != null && prevDNSName != null) {
            return Objects.equals(thisDNSName, prevDNSName);
        }
        X500Principal thisSubject = thisCert.getSubjectX500Principal();
        X500Principal prevSubject = prevCert.getSubjectX500Principal();
        X500Principal thisIssuer = thisCert.getIssuerX500Principal();
        X500Principal prevIssuer = prevCert.getIssuerX500Principal();
        return !thisSubject.getName().isEmpty() && !prevSubject.getName().isEmpty() && thisSubject.equals(prevSubject) && thisIssuer.equals(prevIssuer);
    }

    private static Object getSubjectAltName(X509Certificate cert, int type) {
        Collection<List<?>> subjectAltNames;
        try {
            subjectAltNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            if (debug != null && Debug.isOn((String)"handshake")) {
                System.out.println("Attempt to obtain subjectAltNames extension failed!");
            }
            return null;
        }
        if (subjectAltNames != null) {
            for (List<?> subjectAltName : subjectAltNames) {
                int subjectAltNameType = (Integer)subjectAltName.get(0);
                if (subjectAltNameType != type) continue;
                return subjectAltName.get(1);
            }
        }
        return null;
    }

    @Override
    void sendNextProtocol(NextProtoNego.Provider provider) throws IOException {
        if (this.isInitialHandshake && provider != null) {
            if (this.protocols == null) {
                if (NextProtoNego.debug) {
                    System.err.println(new StringBuilder("[C] NPN not received for ").append(this.conn != null ? this.conn : this.engine));
                }
                ((NextProtoNego.ClientProvider)provider).unsupported();
            } else {
                try {
                    String protocol = ((NextProtoNego.ClientProvider)provider).selectProtocol(this.protocols);
                    if (NextProtoNego.debug) {
                        System.err.println(new StringBuilder("[C] NPN selected '").append(protocol).append("' for ").append(this.conn != null ? this.conn : this.engine));
                    }
                    new NextProtocolMessage(protocol).write(this.output);
                    this.output.flush();
                }
                catch (Throwable t) {
                    this.fatalSE((byte)40, "NPN protocol selection failure", t);
                }
            }
        }
    }

    @Override
    HandshakeMessage.Finished updateFinished(HandshakeMessage.Finished message) {
        if (!this.isInitialHandshake) {
            return message;
        }
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret(), this.cipherSuite);
        byte[] source = finished.getVerifyData();
        System.arraycopy(source, 0, message.getVerifyData(), 0, source.length);
        return finished;
    }
}

