/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.security;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityException;
import org.mule.tck.security.TestSingleUserSecurityProvider;

public class TestMultiuserSecurityProvider
extends TestSingleUserSecurityProvider {
    private Map<String, Authentication> authentications;

    public TestMultiuserSecurityProvider() {
        super("multi-user-test");
    }

    protected void doInitialise() throws InitialisationException {
        this.authentications = new ConcurrentHashMap();
    }

    public Authentication authenticate(Authentication authentication) throws SecurityException {
        String user = (String)authentication.getPrincipal();
        this.logger.debug((Object)("Authenticating user: " + user));
        Authentication oldAuth = this.authentications.get(user);
        if (oldAuth != null) {
            authentication = oldAuth;
            Map props = authentication.getProperties();
            int numberLogins = (Integer)props.get("NUMBER_LOGINS");
            String favoriteColor = (String)props.get("FAVORITE_COLOR");
            props.put("NUMBER_LOGINS", numberLogins + 1);
            authentication.setProperties(props);
            this.authentications.put(user, authentication);
            this.logger.info((Object)("Welcome back " + user + " (" + numberLogins + 1 + " logins), we remembered your favorite color: " + favoriteColor));
        } else {
            String favoriteColor = this.getFavoriteColor(user);
            this.logger.info((Object)("First login for user: " + user + ", favorite color is " + favoriteColor));
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("NUMBER_LOGINS", 1);
            props.put("FAVORITE_COLOR", favoriteColor);
            authentication.setProperties(props);
            this.authentications.put(user, authentication);
        }
        return authentication;
    }
}

