/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.junit.rules.ExternalResource;

public class SystemProperty
extends ExternalResource {
    protected boolean initialized;
    protected String value;
    private final String name;
    private String oldValue;

    public SystemProperty(String name) {
        this(name, null);
    }

    public SystemProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    protected void before() throws Throwable {
        if (this.initialized) {
            throw new IllegalArgumentException("System property was already initialized");
        }
        this.oldValue = this.getValue() == null ? System.clearProperty(this.name) : System.setProperty(this.name, this.getValue());
        this.initialized = true;
    }

    protected void after() {
        if (!this.initialized) {
            throw new IllegalArgumentException("System property was not initialized");
        }
        this.doCleanUp();
        this.restoreOldValue();
        this.initialized = false;
    }

    protected void restoreOldValue() {
        if (this.oldValue == null) {
            System.clearProperty(this.name);
        } else {
            System.setProperty(this.name, this.oldValue);
        }
    }

    public String getName() {
        return this.name;
    }

    protected void doCleanUp() {
    }

    public String getValue() {
        return this.value;
    }
}

