/**
 * @license
 * Copyright (c) 2021 - 2024 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */

let uniqueId = 0;

/**
 * Resets the unique id counter.
 *
 * @return {void}
 */
export function resetUniqueId() {
  uniqueId = 0;
}

/**
 * Returns a unique integer id.
 *
 * @return {number}
 */
export function generateUniqueId() {
  // eslint-disable-next-line no-plusplus
  return uniqueId++;
}
