/**
 * @license
 * Copyright (c) 2021 - 2024 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
import type { Constructor } from '@open-wc/dedupe-mixin';

/**
 * Mixin which enables the font icon sizing fallback for browsers that do not support CSS Container Queries.
 * The mixin does nothing if the browser supports CSS Container Query units for pseudo elements.
 */
export declare function IconFontSizeMixin<T extends Constructor<HTMLElement>>(
  base: T,
): Constructor<IconFontSizeMixinClass> & T;

export declare class IconFontSizeMixinClass {}
