/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.groovy.buildernodes;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.groovy.BuilderNode;

public abstract class AbstractBuilderNode
implements BuilderNode,
Serializable {
    private final String nodeName;
    private Set supportedAttributes = new HashSet();

    public AbstractBuilderNode(String nodeName) {
        this.nodeName = nodeName;
    }

    protected AbstractBuilderNode addAttribute(String name) {
        this.supportedAttributes.add(name);
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Set getSupportedAttributes() {
        return Collections.unmodifiableSet(this.supportedAttributes);
    }

    public String toString() {
        return "Nanocontainer Builder Node: " + this.getClass().getName() + " (\"" + this.getNodeName() + "\")";
    }

    protected boolean isAttribute(Map attributes, String key) {
        return attributes.containsKey(key) && attributes.get(key) != null;
    }

    public void validateScriptedAttributes(Map specifiedAttributes) throws NanoContainerMarkupException {
        Set specifiedAttributeNames = specifiedAttributes.keySet();
        if (this.getSupportedAttributes().containsAll(specifiedAttributeNames)) {
            return;
        }
        HashSet unknownAttributes = new HashSet(specifiedAttributeNames);
        unknownAttributes.removeAll(this.getSupportedAttributes());
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append("Found one or more unknown attributes for builder node '");
        errorMessage.append(this.getNodeName());
        errorMessage.append("': ");
        errorMessage.append(this.convertSetToCommaDelimitedString(unknownAttributes));
        errorMessage.append(".  Recognized Attributes For this node are [");
        errorMessage.append(this.convertSetToCommaDelimitedString(this.getSupportedAttributes()));
        errorMessage.append("].");
        throw new NanoContainerMarkupException(errorMessage.toString());
    }

    private String convertSetToCommaDelimitedString(Set specifiedSet) {
        StringBuffer result = new StringBuffer();
        boolean needComma = false;
        Iterator i = specifiedSet.iterator();
        while (i.hasNext()) {
            if (needComma) {
                result.append(",");
            } else {
                needComma = true;
            }
            result.append(i.next().toString());
        }
        return result.toString();
    }
}

