/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration.validation;

import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.server.configuration.validation.RuleFailedException;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;

public class ValidatorTest {
    @Test
    public void shouldFailWhenRuleFails() {
        Validator v = new Validator(new ValidationRule[]{new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
                throw new RuleFailedException("dummy rule failed during unit test");
            }
        }});
        Assert.assertFalse((boolean)v.validate(null, ConsoleLogger.DEV_NULL));
    }

    @Test
    public void shouldFailWhenAtLeastOneRuleFails() {
        Validator v = new Validator(new ValidationRule[]{new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }, new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
                throw new RuleFailedException("dummy rule failed during unit test");
            }
        }, new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }, new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }});
        Assert.assertFalse((boolean)v.validate(null, ConsoleLogger.DEV_NULL));
    }

    @Test
    public void shouldPassWhenAllRulesComplete() {
        Validator v = new Validator(new ValidationRule[]{new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }, new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }, new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }, new ValidationRule(){

            public void validate(Configuration configuration) throws RuleFailedException {
            }
        }});
        Assert.assertTrue((boolean)v.validate(null, ConsoleLogger.DEV_NULL));
    }
}

