/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;

public class JSONPrettifier {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectWriter WRITER = MAPPER.writerWithDefaultPrettyPrinter();

    public static String parse(String json) {
        if (json == null) {
            return "";
        }
        String result = json;
        try {
            result = json.contains("\"exception\"") ? JSONPrettifier.gsonPrettyPrint(json) : JSONPrettifier.jacksonPrettyPrint(json);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String gsonPrettyPrint(String json) throws Exception {
        JsonElement element = JSON_PARSER.parse(json);
        return GSON.toJson(element);
    }

    private static String jacksonPrettyPrint(String json) throws Exception {
        Object myObject = MAPPER.readValue(json, Object.class);
        return WRITER.writeValueAsString(myObject);
    }
}

