/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.security.UriPathWildcardMatcher;

public class UriPathWildcardMatcherTest {
    @Test
    public void shouldFailWithoutAsteriskAtStart() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("/some/uri/path");
        Assert.assertFalse((boolean)matcher.matches("preamble/some/uri/path"));
    }

    @Test
    public void shouldFailWithoutAsteriskAtEnd() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("/some/uri/path/and/some/more");
        Assert.assertFalse((boolean)matcher.matches("/some/uri/path/with/middle/bit/and/some/more"));
    }

    @Test
    public void shouldMatchAsteriskAtStart() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("*/some/uri/path");
        Assert.assertTrue((boolean)matcher.matches("anything/i/like/followed/by/some/uri/path"));
        Assert.assertFalse((boolean)matcher.matches("anything/i/like/followed/by/some/deliberately/changed/to/fail/uri/path"));
    }

    @Test
    public void shouldMatchAsteriskAtEnd() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("/some/uri/path/*");
        Assert.assertTrue((boolean)matcher.matches("/some/uri/path/followed/by/anything/i/like"));
    }

    @Test
    public void shouldMatchAsteriskInMiddle() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("/some/uri/path/*/and/some/more");
        Assert.assertTrue((boolean)matcher.matches("/some/uri/path/with/middle/bit/and/some/more"));
    }

    @Test
    public void shouldMatchMultipleAsterisksInMiddle() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("/some/uri/path/*/and/some/more/*/and/a/final/bit");
        Assert.assertTrue((boolean)matcher.matches("/some/uri/path/with/middle/bit/and/some/more/with/additional/asterisk/part/and/a/final/bit"));
    }

    @Test
    public void shouldMatchMultipleAsterisksAtStartAndInMiddle() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("*/some/uri/path/*/and/some/more/*/and/a/final/bit");
        Assert.assertTrue((boolean)matcher.matches("a/bit/of/preamble/and/then/some/uri/path/with/middle/bit/and/some/more/with/additional/asterisk/part/and/a/final/bit"));
    }

    @Test
    public void shouldMatchMultipleAsterisksAtEndAndInMiddle() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("/some/uri/path/*/and/some/more/*/and/a/final/bit/*");
        Assert.assertTrue((boolean)matcher.matches("/some/uri/path/with/middle/bit/and/some/more/with/additional/asterisk/part/and/a/final/bit/and/now/some/post/amble"));
    }

    @Test
    public void shouldMatchMultipleAsterisksAtStartAndEndAndInMiddle() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("*/some/uri/path/*/and/some/more/*/and/a/final/bit/*");
        Assert.assertTrue((boolean)matcher.matches("a/bit/of/preamble/and/then//some/uri/path/with/middle/bit/and/some/more/with/additional/asterisk/part/and/a/final/bit/and/now/some/post/amble"));
    }

    @Test
    public void shouldMatchMultipleSimpleString() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("str");
        Assert.assertTrue((boolean)matcher.matches("str"));
    }

    @Test
    public void shouldMatchMultipleSimpleStringWithALeadingWildcard() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("*str");
        Assert.assertTrue((boolean)matcher.matches("my_str"));
    }

    @Test
    public void shouldFailToMatchMultipleSimpleStringWithATrailingWildcard() {
        UriPathWildcardMatcher matcher = new UriPathWildcardMatcher("str*");
        Assert.assertFalse((boolean)matcher.matches("my_str"));
    }
}

