/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import java.util.Date;
import org.hamcrest.Matcher;
import org.neo4j.server.webdriver.ConditionTimeoutException;

public class Condition<T> {
    private final T state;
    private final Matcher<T> matcher;

    public Condition(Matcher<T> matcher, T state) {
        this.matcher = matcher;
        this.state = state;
    }

    public boolean isFulfilled() {
        return this.matcher.matches(this.state);
    }

    public void waitUntilFulfilled() {
        this.waitUntilFulfilled(10000L);
    }

    public void waitUntilFulfilled(long timeout) {
        this.waitUntilFulfilled(timeout, "Condition was not fulfilled within the time limit (" + timeout + "ms).");
    }

    public void waitUntilFulfilled(long timeout, String errorMessage) {
        timeout = new Date().getTime() + timeout;
        while (new Date().getTime() < timeout) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!this.isFulfilled()) continue;
            return;
        }
        throw new ConditionTimeoutException(errorMessage);
    }
}

