/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.net.URI;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ConfigWrappingConfiguration;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.web.ServerInternalSettings;

public class ConfigWrappingConfigurationTest {
    @Test
    public void shouldGetDefaultPropertyByKey() throws Exception {
        Config config = new Config();
        PropertyFileConfigurator.setServerSettingsClasses((Config)config);
        ConfigWrappingConfiguration wrappingConfiguration = new ConfigWrappingConfiguration(config);
        Object propertyValue = wrappingConfiguration.getProperty(ServerInternalSettings.rest_api_path.name());
        Assert.assertEquals((Object)new URI(ServerInternalSettings.rest_api_path.getDefaultValue()), (Object)propertyValue);
    }

    @Test
    public void shouldGetPropertyInRightFormat() throws Exception {
        Config config = new Config();
        PropertyFileConfigurator.setServerSettingsClasses((Config)config);
        ConfigWrappingConfiguration wrappingConfiguration = new ConfigWrappingConfiguration(config);
        wrappingConfiguration.setProperty(ServerInternalSettings.rest_api_path.name(), (Object)"http://localhost:7474///db///data///");
        Object dataPath = wrappingConfiguration.getProperty(ServerInternalSettings.rest_api_path.name());
        Assert.assertEquals((Object)new URI(ServerInternalSettings.rest_api_path.getDefaultValue()), (Object)dataPath);
    }

    @Test
    public void shouldContainAllKeysOfPropertiesWithDefaultOrUserDefinedValues() throws Exception {
        Config config = new Config();
        PropertyFileConfigurator.setServerSettingsClasses((Config)config);
        ConfigWrappingConfiguration wrappingConfiguration = new ConfigWrappingConfiguration(config);
        Assert.assertTrue((boolean)wrappingConfiguration.getKeys().hasNext());
    }
}

