/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.formats.CompactJsonFormat;

public class CompactJsonDocIT
extends AbstractRestFunctionalTestBase {
    private long thomasAnderson;
    private long trinity;
    private long thomasAndersonLovesTrinity;
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(CompactJsonDocIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void setupTheDatabase() {
        this.cleanDatabase();
        this.createTheMatrix();
    }

    private void createTheMatrix() {
        this.thomasAnderson = this.createAndIndexNode("Thomas Anderson");
        this.trinity = this.createAndIndexNode("Trinity");
        long tank = this.createAndIndexNode("Tank");
        long knowsRelationshipId = helper.createRelationship("KNOWS", this.thomasAnderson, this.trinity);
        this.thomasAndersonLovesTrinity = helper.createRelationship("LOVES", this.thomasAnderson, this.trinity);
        helper.setRelationshipProperties(this.thomasAndersonLovesTrinity, Collections.singletonMap("strength", 100));
        helper.createRelationship("KNOWS", this.thomasAnderson, tank);
        helper.createRelationship("KNOWS", this.trinity, tank);
        helper.createRelationshipIndex("relationships");
        helper.addRelationshipToIndex("relationships", "key", "value", knowsRelationshipId);
        helper.createRelationshipIndex("relationships2");
        helper.addRelationshipToIndex("relationships2", "key2", "value2", knowsRelationshipId);
    }

    private long createAndIndexNode(String name) {
        long id = helper.createNode(new Label[0]);
        helper.setNodeProperties(id, Collections.singletonMap("name", name));
        helper.addNodeToIndex("node", "name", name, id);
        return id;
    }

    @Test
    public void shouldGetThomasAndersonDirectly() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.nodeUri(this.thomasAnderson), CompactJsonFormat.MEDIA_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = response.getEntity();
        Assert.assertTrue((boolean)entity.contains("Thomas Anderson"));
        this.assertValidJson(entity);
        response.close();
    }

    private void assertValidJson(String entity) {
        try {
            Assert.assertTrue((boolean)JsonHelper.jsonToMap((String)entity).containsKey("self"));
            Assert.assertFalse((boolean)JsonHelper.jsonToMap((String)entity).containsKey("properties"));
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
    }
}

