/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class PathsDocIT
extends AbstractRestFunctionalTestBase {
    @Test
    @GraphDescription.Graph(value={"a to c", "a to d", "c to b", "d to e", "b to f", "c to f", "f to g", "d to g", "e to g", "c to g"})
    @Documented(value=" The +shortestPath+ algorithm can find multiple paths between the same\n nodes, like in this example.\n")
    @TestData.Title(value="Find all shortest paths")
    public void shouldBeAbleToFindAllShortestPaths() throws PropertyValueException {
        long a = this.nodeId((Map)this.data.get(), "a");
        long g = this.nodeId((Map)this.data.get(), "g");
        String response = this.gen().expectedStatus(Response.Status.OK.getStatusCode()).payload(this.getAllShortestPathPayLoad(g)).post("http://localhost:7474/db/data/node/" + a + "/paths").entity();
        Collection result = (Collection)JsonHelper.jsonToSingleValue((String)response);
        Assert.assertEquals((long)2L, (long)result.size());
        for (Object representation : result) {
            Map path = (Map)representation;
            this.assertThatPathStartsWith(path, a);
            this.assertThatPathEndsWith(path, g);
            this.assertThatPathHasLength(path, 2);
        }
    }

    @TestData.Title(value="Find one of the shortest paths")
    @Test
    @GraphDescription.Graph(value={"a to c", "a to d", "c to b", "d to e", "b to f", "c to f", "f to g", "d to g", "e to g", "c to g"})
    @Documented(value=" If no path algorithm is specified, a +shortestPath+ algorithm with a max\n depth of 1 will be chosen. In this example, the +max_depth+ is set to +3+\n in order to find the shortest path between a maximum of 3 linked nodes.\n")
    public void shouldBeAbleToFetchSingleShortestPath() throws JsonParseException {
        long a = this.nodeId((Map)this.data.get(), "a");
        long g = this.nodeId((Map)this.data.get(), "g");
        String response = this.gen().expectedStatus(Response.Status.OK.getStatusCode()).payload(this.getAllShortestPathPayLoad(g)).post("http://localhost:7474/db/data/node/" + a + "/path").entity();
        Map path = JsonHelper.jsonToMap((String)response);
        this.assertThatPathStartsWith(path, a);
        this.assertThatPathEndsWith(path, g);
        this.assertThatPathHasLength(path, 2);
    }

    private void assertThatPathStartsWith(Map<?, ?> path, long start) {
        Assert.assertTrue((String)("Path should start with " + start + "\nBut it was " + path), (boolean)path.get("start").toString().endsWith("/node/" + start));
    }

    private void assertThatPathEndsWith(Map<?, ?> path, long start) {
        Assert.assertTrue((String)("Path should end with " + start + "\nBut it was " + path), (boolean)path.get("end").toString().endsWith("/node/" + start));
    }

    private void assertThatPathHasLength(Map<?, ?> path, int length) {
        Object actual = path.get("length");
        Assert.assertEquals((String)("Expected path to have a length of " + length + "\nBut it was " + actual), (Object)length, actual);
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="a", setNameProperty=true), @GraphDescription.NODE(name="b", setNameProperty=true), @GraphDescription.NODE(name="c", setNameProperty=true), @GraphDescription.NODE(name="d", setNameProperty=true), @GraphDescription.NODE(name="e", setNameProperty=true), @GraphDescription.NODE(name="f", setNameProperty=true)}, relationships={@GraphDescription.REL(start="a", end="b", type="to", properties={@GraphDescription.PROP(key="cost", value="1.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="a", end="c", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="a", end="f", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="c", end="d", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="d", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="b", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="f", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="1.2", type=GraphDescription.PropType.DOUBLE)})})
    @TestData.Title(value="Execute a Dijkstra algorithm and get a single path")
    @Documented(value=" This example is running a Dijkstra algorithm over a graph with different\n cost properties on different relationships. Note that the request URI\n ends with +/path+ which means a single path is what we want here.\n")
    public void shouldGetCorrectDijkstraPathWithWeights() throws Exception {
        long a = this.nodeId((Map)this.data.get(), "a");
        long e = this.nodeId((Map)this.data.get(), "e");
        String response = this.gen().expectedStatus(Response.Status.OK.getStatusCode()).payload(this.getAllPathsUsingDijkstraPayLoad(e, false)).post("http://localhost:7474/db/data/node/" + a + "/path").entity();
        Map path = JsonHelper.jsonToMap((String)response);
        this.assertThatPathStartsWith(path, a);
        this.assertThatPathEndsWith(path, e);
        this.assertThatPathHasLength(path, 3);
        Assert.assertEquals((Object)1.5, path.get("weight"));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="a", setNameProperty=true), @GraphDescription.NODE(name="b", setNameProperty=true), @GraphDescription.NODE(name="c", setNameProperty=true), @GraphDescription.NODE(name="d", setNameProperty=true), @GraphDescription.NODE(name="e", setNameProperty=true), @GraphDescription.NODE(name="f", setNameProperty=true)}, relationships={@GraphDescription.REL(start="a", end="b", type="to", properties={@GraphDescription.PROP(key="cost", value="1.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="a", end="c", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="a", end="f", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="c", end="d", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="d", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="b", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="0.5", type=GraphDescription.PropType.DOUBLE)}), @GraphDescription.REL(start="f", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="1.0", type=GraphDescription.PropType.DOUBLE)})})
    @TestData.Title(value="Execute a Dijkstra algorithm and get multiple paths")
    @Documented(value=" This example is running a Dijkstra algorithm over a graph with different\n cost properties on different relationships. Note that the request URI\n ends with +/paths+ which means we want multiple paths returned, in case\n they exist.\n")
    public void shouldGetCorrectDijkstraPathsWithWeights() throws Exception {
        long a = this.nodeId((Map)this.data.get(), "a");
        long e = this.nodeId((Map)this.data.get(), "e");
        String response = this.gen().expectedStatus(Response.Status.OK.getStatusCode()).payload(this.getAllPathsUsingDijkstraPayLoad(e, false)).post("http://localhost:7474/db/data/node/" + a + "/paths").entity();
        List list = JsonHelper.jsonToList((String)response);
        Assert.assertEquals((long)2L, (long)list.size());
        Map firstPath = (Map)list.get(0);
        Map secondPath = (Map)list.get(1);
        System.out.println(firstPath);
        System.out.println(secondPath);
        this.assertThatPathStartsWith(firstPath, a);
        this.assertThatPathStartsWith(secondPath, a);
        this.assertThatPathEndsWith(firstPath, e);
        this.assertThatPathEndsWith(secondPath, e);
        Assert.assertEquals((Object)1.5, firstPath.get("weight"));
        Assert.assertEquals((Object)1.5, secondPath.get("weight"));
        Assert.assertEquals((long)5L, (long)((Integer)firstPath.get("length") + (Integer)secondPath.get("length")));
        this.assertThatPathHasLength(firstPath, 3);
        this.assertThatPathHasLength(secondPath, 2);
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="a", setNameProperty=true), @GraphDescription.NODE(name="b", setNameProperty=true), @GraphDescription.NODE(name="c", setNameProperty=true), @GraphDescription.NODE(name="d", setNameProperty=true), @GraphDescription.NODE(name="e", setNameProperty=true), @GraphDescription.NODE(name="f", setNameProperty=true)}, relationships={@GraphDescription.REL(start="a", end="b", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)}), @GraphDescription.REL(start="a", end="c", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)}), @GraphDescription.REL(start="a", end="f", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)}), @GraphDescription.REL(start="c", end="d", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)}), @GraphDescription.REL(start="d", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)}), @GraphDescription.REL(start="b", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)}), @GraphDescription.REL(start="f", end="e", type="to", properties={@GraphDescription.PROP(key="cost", value="1", type=GraphDescription.PropType.INTEGER)})})
    @TestData.Title(value="Execute a Dijkstra algorithm with equal weights on relationships")
    @Documented(value=" The following is executing a Dijkstra search on a graph with equal\n weights on all relationships. This example is included to show the\n difference when the same graph structure is used, but the path weight is\n equal to the number of hops.\n")
    public void shouldGetCorrectDijkstraPathsWithEqualWeightsWithDefaultCost() throws Exception {
        long a = this.nodeId((Map)this.data.get(), "a");
        long e = this.nodeId((Map)this.data.get(), "e");
        String response = this.gen().expectedStatus(Response.Status.OK.getStatusCode()).payload(this.getAllPathsUsingDijkstraPayLoad(e, false)).post("http://localhost:7474/db/data/node/" + a + "/path").entity();
        Map path = JsonHelper.jsonToMap((String)response);
        this.assertThatPathStartsWith(path, a);
        this.assertThatPathEndsWith(path, e);
        this.assertThatPathHasLength(path, 2);
        Assert.assertEquals((Object)2.0, path.get("weight"));
    }

    @Test
    @GraphDescription.Graph(value={"a to c", "a to d", "c to b", "d to e", "b to f", "c to f", "f to g", "d to g", "e to g", "c to g"})
    public void shouldReturn404WhenFailingToFindASinglePath() throws JsonParseException {
        long a = this.nodeId((Map)this.data.get(), "a");
        long g = this.nodeId((Map)this.data.get(), "g");
        String noHitsJson = "{\"to\":\"" + this.nodeUri(g) + "\", \"max_depth\":1, \"relationships\":{\"type\":\"dummy\", \"direction\":\"in\"}, \"algorithm\":\"shortestPath\"}";
        String entity = this.gen().expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).payload(noHitsJson).post("http://localhost:7474/db/data/node/" + a + "/path").entity();
        System.out.println(entity);
    }

    private long nodeId(Map<String, Node> map, String string) {
        return map.get(string).getId();
    }

    private String nodeUri(long l) {
        return "http://localhost:7474/db/data/node/" + l;
    }

    private String getAllShortestPathPayLoad(long to) {
        String json = "{\"to\":\"" + this.nodeUri(to) + "\", \"max_depth\":3, \"relationships\":{\"type\":\"to\", \"direction\":\"out\"}, \"algorithm\":\"shortestPath\"}";
        return json;
    }

    private String getAllPathsUsingDijkstraPayLoad(long to, boolean includeDefaultCost) {
        String json = "{\"to\":\"" + this.nodeUri(to) + "\"" + ", \"cost_property\":\"cost\"" + (includeDefaultCost ? ", \"default_cost\":1" : "") + ", \"relationships\":{\"type\":\"to\", \"direction\":\"out\"}, \"algorithm\":\"dijkstra\"}";
        return json;
    }
}

