/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.test.Property;
import org.neo4j.test.mocking.GraphMock;
import org.neo4j.test.mocking.Properties;

public class RelationshipRepresentationTest {
    @Test
    public void shouldHaveSelfLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", this.relrep(1234L).selfUri());
    }

    @Test
    public void shouldHaveType() {
        Assert.assertNotNull((Object)this.relrep(1234L).getType());
    }

    @Test
    public void shouldHaveStartNodeLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", this.relrep(1234L).startNodeUri());
    }

    @Test
    public void shouldHaveEndNodeLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", this.relrep(1234L).endNodeUri());
    }

    @Test
    public void shouldHavePropertiesLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties", this.relrep(1234L).propertiesUri());
    }

    @Test
    public void shouldHavePropertyLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties/\\{key\\}", this.relrep(1234L).propertyUriTemplate());
    }

    @Test
    public void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize((MappingRepresentation)this.relrep(1234L));
        Assert.assertNotNull(repr);
        RelationshipRepresentationTest.verifySerialisation(repr);
    }

    private RelationshipRepresentation relrep(long id) {
        return new RelationshipRepresentation(GraphMock.relationship((long)id, (Node)GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]), (String)"LOVES", (Node)GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]), (Property[])new Property[0]));
    }

    public static void verifySerialisation(Map<String, Object> relrep) {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", relrep.get("self").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", relrep.get("start").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", relrep.get("end").toString());
        Assert.assertNotNull((Object)relrep.get("type"));
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties", relrep.get("properties").toString());
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties/\\{key\\}", (String)relrep.get("property"));
        Assert.assertNotNull((Object)relrep.get("data"));
        Assert.assertNotNull((Object)relrep.get("metadata"));
        Map metadata = (Map)relrep.get("metadata");
        Assert.assertNotNull(metadata.get("type"));
        Assert.assertTrue((((Number)metadata.get("id")).longValue() >= 0L ? 1 : 0) != 0);
    }
}

