/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class JsonInputTest {
    private final JsonFormat input = new JsonFormat();

    @Test
    public void canReadEmptyMap() throws Exception {
        Map map = this.input.readMap("{}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((String)"map is not empty", (boolean)map.isEmpty());
    }

    @Test
    public void canReadMapWithTwoValues() throws Exception {
        Map map = this.input.readMap("{\"key1\":\"value1\",     \"key2\":\"value11\"}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)"key1", (Object)"value1"));
        Assert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)"key2", (Object)"value11"));
        Assert.assertTrue((String)"map contained extra values", (map.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void canReadMapWithNestedMap() throws Exception {
        Map map = this.input.readMap("{\"nested\": {\"key\": \"valuable\"}}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"nested"));
        Assert.assertTrue((String)"map contained extra values", (map.size() == 1 ? 1 : 0) != 0);
        Object nested = map.get("nested");
        Assert.assertThat(nested, (Matcher)Matchers.instanceOf(Map.class));
        Map nestedMap = (Map)nested;
        Assert.assertThat((Object)nestedMap, (Matcher)Matchers.hasEntry((Object)"key", (Object)"valuable"));
    }

    @Test
    public void canReadStringWithLineBreaks() throws Exception {
        Map map = this.input.readMap("{\"key\": \"v1\\nv2\"}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals(map.get("key"), (Object)"v1\nv2");
    }
}

