/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.sun.jersey.core.util.Base64;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class AuthenticationDocIT
extends ExclusiveServerTestBase {
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);
    private CommunityNeoServer server;

    @Before
    public void setUp() {
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("dev/rest-api");
    }

    @Test
    @Documented(value=" Required password changes\n\n In some cases, like the very first time you access Neo4j with authorization enabled, you are required to choose\n a new password. The database will signal that a new password is required when you try to authenticate.\n\n See <<rest-api-changing-your-password>> for how to set a new password.\n")
    public void password_change_required() throws PropertyValueException, IOException {
        this.startServer(true);
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'username':'neo4j', 'password':'neo4j'}")).post(this.authURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("username").asText(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
        Assert.assertThat((Object)data.has("authorization_token"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)data.has("authorization_token_change"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)data.get("password_change_required").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)data.get("password_change").asText(), (Matcher)CoreMatchers.equalTo((Object)this.server.baseUri().resolve("user/neo4j/password").toString()));
    }

    @Test
    @Documented(value=" Authenticate to obtain an authorization token\n\n You authenticate by sending a username and a password to Neo4j. The database will reply with an authorization\n token. The reply from this endpoint will also indicate if your password should be changed which will,\n for instance, be the case in a newly installed instance.\n")
    public void successful_authentication() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(this.quotedJson("{'username':'neo4j', 'password':'secret'}")).post(this.authURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("username").asText(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
        Assert.assertThat((Object)data.get("password_change_required").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)data.get("authorization_token").asText().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)data.get("authorization_token_change").asText(), (Matcher)CoreMatchers.equalTo((Object)this.server.baseUri().resolve("user/neo4j/authorization_token").toString()));
    }

    @Test
    @Documented(value=" Using the Authorization Token\n\n Given that you have acquired an authorization token, you may use it to get access to the rest of the API.\n To include the token in requests to the server, it should be encoded as the 'password' part of the HTTP Basic Auth scheme.\n This means you should include a +Authorization+ header, with a value of +Basic realm=\"Neo4j\" <token payload>+\n where \"token payload\" is a base64 encoded string of the token prepended by a colon.\n\n In pseudo-code:\n\n [source,javascript]\n ----\n authorization = 'Basic realm=\"Neo4j\" ' + base64( ':' + token );\n ----\n")
    public void using_the_token() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        String token = HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).get("authorization_token").asText();
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).withHeader("Authorization", this.challengeResponse(token)).get(this.server.baseUri().resolve("").toString());
    }

    @Test
    @Documented(value=" Incorrect username or password\n\n If you provide incorrect authentication credentials, the server replies with a an error.\n")
    public void incorrect_authentication() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(422).payload(this.quotedJson("{'username':'bob', 'password':'incorrect'}")).post(this.authURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthenticationFailed"));
        Assert.assertThat((Object)data.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid username and/or password."));
    }

    @Test
    @Documented(value=" Get current authorization status\n\n You can use this endpoint to determine if security is enabled, and to check if your authorization token is valid.\n\n Given that you have a valid authorization token, you can retrieve metadata about the current user from the authentication endpoint.\n If Neo4j security is disabled, this endpoint will also return `200 OK`, see <<rest-api-get-authorization-status-when-authorization-is-disabled>>.\n If security is enabled and your token is invalid, you will get an error reply, see <<rest-api-attempting-to-get-authorization-status-while-unauthorized>>.\n This way, you can use this endpoint to determine if you need to acquire an authorization token.\n")
    public void authorization_metadata() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        String authToken = HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).get("authorization_token").asText();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).withHeader("Authorization", this.challengeResponse(authToken)).get(this.authURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("username").asText(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
    }

    @Test
    @Documented(value=" Attempting to get authorization status while unauthorized\n\n Given that you have an invalid authorization token, or no token at all, asking for authorization status leads\n to an unauthorized HTTP reply.\n")
    public void disallowed_authorization_metadata() throws PropertyValueException, IOException {
        this.startServerWithConfiguredUser();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(401).expectedHeader("WWW-Authenticate", "None").withHeader("Authorization", "Basic realm=\"Neo4j\" " + this.base64(":helloworld")).get(this.authURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthorizationFailed"));
        Assert.assertThat((Object)data.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid authorization token supplied."));
    }

    @Test
    @Documented(value=" Get authorization status when authorization is disabled\n\n Given that authorization is disabled in the configuration, you can perform a `GET` request to the authentication endpoint, and will\n get back an `200 OK` response. You will not receive a username or authorization token.\n")
    public void auth_disabled_get_metadata() throws PropertyValueException, IOException {
        this.startServer(false);
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.authURL());
    }

    @Test
    public void shouldSayTokenMissingIfNoTokenProvided() throws Exception {
        this.startServerWithConfiguredUser();
        HTTP.Response response = HTTP.GET(this.authURL());
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)401));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthorizationFailed"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"No authorization token supplied."));
        Assert.assertThat((Object)response.header("WWW-Authenticate"), (Matcher)CoreMatchers.equalTo((Object)"None"));
    }

    @Test
    public void shouldSayMalformedTokenIfMalformedToken() throws Exception {
        this.startServerWithConfiguredUser();
        HTTP.Response response = HTTP.withHeaders("Authorization", "This makes no sense").GET(this.authURL());
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Request.InvalidFormat"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid Authorization header."));
    }

    @Test
    public void shouldHandleMissingParameters() throws Exception {
        this.startServerWithConfiguredUser();
        Assert.assertEquals((long)422L, (long)HTTP.POST(this.authURL()).status());
        Assert.assertEquals((long)422L, (long)HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'password':'whatever'}")).status());
        Assert.assertEquals((long)422L, (long)HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'password':1234, 'username':{}}")).status());
    }

    @Test
    public void shouldNotAllowDataAccess() throws Exception {
        this.startServerWithConfiguredUser();
        this.assertAuthorizationRequired("POST", "db/data/node", HTTP.RawPayload.quotedJson("{'name':'jake'}"), 201);
        this.assertAuthorizationRequired("GET", "db/data/node/1234", 404);
        this.assertAuthorizationRequired("POST", "db/data/transaction/commit", HTTP.RawPayload.quotedJson("{'statements':[{'statement':'MATCH (n) RETURN n'}]}"), 200);
        Assert.assertEquals((long)200L, (long)HTTP.GET(this.server.baseUri().resolve("webadmin").toString()).status());
        Assert.assertEquals((long)200L, (long)HTTP.GET(this.server.baseUri().resolve("browser").toString()).status());
        Assert.assertEquals((long)200L, (long)HTTP.GET(this.server.baseUri().resolve("").toString()).status());
    }

    @Test
    public void rootEndpointShouldOnlyShowAuthenticationDiscoverabilityUrl() throws Exception {
        this.startServerWithConfiguredUser();
        HTTP.Response res = HTTP.GET(this.server.baseUri().resolve("").toString());
        Assert.assertThat((Object)res.rawContent(), (Matcher)CoreMatchers.equalTo((Object)String.format("{%n  \"authentication\" : \"" + this.server.baseUri().resolve("authentication") + "\"%n" + "}", new Object[0])));
    }

    @Test
    public void shouldAllowAllAccessIfAuthenticationIsDisabled() throws Exception {
        this.startServer(false);
        Assert.assertEquals((long)201L, (long)HTTP.POST(this.server.baseUri().resolve("db/data/node").toString(), HTTP.RawPayload.quotedJson("{'name':'jake'}")).status());
        Assert.assertEquals((long)404L, (long)HTTP.GET(this.server.baseUri().resolve("db/data/node/1234").toString()).status());
        Assert.assertEquals((long)200L, (long)HTTP.POST(this.server.baseUri().resolve("db/data/transaction/commit").toString(), HTTP.RawPayload.quotedJson("{'statements':[{'statement':'MATCH (n) RETURN n'}]}")).status());
    }

    @Test
    public void shouldReplyNicelyToTooManyFailedAuthAttempts() throws Exception {
        this.startServerWithConfiguredUser();
        long timeout = System.currentTimeMillis() + 30000L;
        HTTP.Response response = null;
        while (System.currentTimeMillis() < timeout && (response = HTTP.POST(this.server.baseUri().resolve("authentication").toString(), HTTP.RawPayload.quotedJson("{'username':'neo4j', 'password':'something that is wrong'}"))).status() != 429) {
        }
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)429));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthenticationRateLimit"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Too many failed authentication requests. Please try again in 5 seconds."));
    }

    private void assertAuthorizationRequired(String method, String path, int expectedAuthorizedStatus) throws JsonParseException {
        this.assertAuthorizationRequired(method, path, null, expectedAuthorizedStatus);
    }

    private void assertAuthorizationRequired(String method, String path, Object payload, int expectedAuthorizedStatus) throws JsonParseException {
        HTTP.Response response = HTTP.request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)401));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthorizationFailed"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"No authorization token supplied."));
        Assert.assertThat((Object)response.get("authentication").asText(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:7474/authentication"));
        Assert.assertThat((Object)response.header("WWW-Authenticate"), (Matcher)CoreMatchers.equalTo((Object)"None"));
        response = HTTP.withHeaders("Authorization", "This makes no sense").request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Request.InvalidFormat"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid Authorization header."));
        response = HTTP.withHeaders("Authorization", "Basic realm=\"Neo4j\" " + this.base64(":helloworld")).request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)401));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Security.AuthorizationFailed"));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid authorization token supplied."));
        Assert.assertThat((Object)response.get("authentication").asText(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:7474/authentication"));
        Assert.assertThat((Object)response.header("WWW-Authenticate"), (Matcher)CoreMatchers.equalTo((Object)"None"));
        String token = HTTP.POST(this.authURL(), HTTP.RawPayload.quotedJson("{'username':'neo4j','password':'secret'}")).get("authorization_token").asText();
        response = HTTP.withHeaders("Authorization", this.challengeResponse(token)).request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)expectedAuthorizedStatus));
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void startServerWithConfiguredUser() throws IOException {
        this.startServer(true);
        HTTP.Response put = HTTP.POST(this.server.baseUri().resolve("/user/neo4j/password").toString(), HTTP.RawPayload.quotedJson("{'password':'neo4j', 'new_password':'secret'}"));
        Assert.assertEquals((long)200L, (long)put.status());
    }

    public void startServer(boolean authEnabled) throws IOException {
        new File("neo4j-home/data/dbms/authorization").delete();
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.authorization_enabled.name(), Boolean.toString(authEnabled)).build();
        this.server.start();
    }

    private String challengeResponse(String token) {
        return "Basic realm=\"Neo4j\" " + this.base64(":" + token);
    }

    private String authURL() {
        return this.server.baseUri().resolve("authentication").toString();
    }

    private String base64(String value) {
        return new String(Base64.encode((String)value), Charset.forName("UTF-8"));
    }

    private String quotedJson(String singleQuoted) {
        return singleQuoted.replaceAll("'", "\"");
    }
}

